<?php

namespace App\Exports;

use App\Models\Guru;
use Illuminate\Support\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class GuruExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function collection()
    {
        return Guru::orderBy('nama_guru')
            ->get()
            ->map(function ($g) {
                // kalau tanggal_lahir string biasa, parse dulu
                $tgl = null;
                if (!empty($g->tanggal_lahir)) {
                    try {
                        $tgl = Carbon::parse($g->tanggal_lahir)->format('Y-m-d');
                    } catch (\Throwable $e) {
                        $tgl = $g->tanggal_lahir;
                    }
                }

                return [
                    'semester'                                     => null,
                    'sekolah_id'                                   => $g->sekolah_id,
                    'nama'                                         => $g->nama_guru,
                    'nip'                                          => $g->nip,
                    'jenis_kelamin'                                => null,
                    'tempat_lahir'                                 => $g->tempat_lahir,
                    'tanggal_lahir'                                => $tgl,
                    'nuptk'                                        => $g->nuptk,
                    'status_kepegawaian'                           => null,
                    'jenis_ptk'                                    => null,
                    'agama'                                        => $g->agama,
                    'email'                                        => $g->email,
                    'status_keaktifan'                             => null,
                    'tmt_pengangkatan'                             => null,
                    'lembaga_pengangkat'                           => null,
                    'pangkat_golongan'                             => $g->pangkat_golongan,
                    'keahlian_laboratorium'                        => null,
                    'status_perkawinan'                            => null,
                    'sudah_lisensi_kepala_sekolah'                 => null,
                    'pernah_diklat_kepengawasan'                   => null,
                    'mampu_handle_kk'                              => null,
                    'keahlian_braille'                             => null,
                    'keahlian_bhs_isyarat'                         => null,
                    'ptk_induk'                                    => null,
                    'jenis_keluar'                                 => null,
                    'riwayat_sertifikasi_bidang_studi'            => null,
                    'riwayat_sertifikasi_jenis_sertifikasi'       => null,
                    'riwayat_sertifikasi_tahun_sertifikasi'       => null,
                    'riwayat_sertifikasi_nomor_sertifikat'        => null,
                    'riwayat_sertifikasi_nrg'                     => null,
                    'riwayat_pendidikan_formal_bidang_studi'      => null,
                    'riwayat_pendidikan_formal_jenjang_pendidikan'=> null,
                    'jabatan_ptk'                                  => null,
                ];
            });
    }

    public function headings(): array
    {
        return [
            'semester',
            'sekolah_id',
            'nama',
            'nip',
            'jenis_kelamin',
            'tempat_lahir',
            'tanggal_lahir',
            'nuptk',
            'status_kepegawaian',
            'jenis_ptk',
            'agama',
            'email',
            'status_keaktifan',
            'tmt_pengangkatan',
            'lembaga_pengangkat',
            'pangkat_golongan',
            'keahlian_laboratorium',
            'status_perkawinan',
            'sudah_lisensi_kepala_sekolah',
            'pernah_diklat_kepengawasan',
            'mampu_handle_kk',
            'keahlian_braille',
            'keahlian_bhs_isyarat',
            'ptk_induk',
            'jenis_keluar',
            'riwayat_sertifikasi_bidang_studi',
            'riwayat_sertifikasi_jenis_sertifikasi',
            'riwayat_sertifikasi_tahun_sertifikasi',
            'riwayat_sertifikasi_nomor_sertifikat',
            'riwayat_sertifikasi_nrg',
            'riwayat_pendidikan_formal_bidang_studi',
            'riwayat_pendidikan_formal_jenjang_pendidikan',
            'jabatan_ptk',
        ];
    }
}
