<?php

namespace App\Http\Controllers;

use App\Models\Guru;
use App\Models\Sekolah;
use App\Models\Pelatihan;
use App\Models\PelatihanPeserta;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Card angka-angka utama
        $totalSekolah   = Sekolah::count();
        $totalPtk       = Guru::count();
        $totalPelatihan = Pelatihan::count();
        $totalPeserta   = PelatihanPeserta::count();

        // Ringkasan pelatihan per kategori
        $ringkasanPelatihan = Pelatihan::select('kategori', DB::raw('COUNT(*) as total'))
            ->groupBy('kategori')
            ->pluck('total', 'kategori');

        $pelBk                   = $ringkasanPelatihan['BK'] ?? 0;
        $pelMat                  = $ringkasanPelatihan['Matematika'] ?? 0;
        $pelTendik               = $ringkasanPelatihan['Tendik'] ?? 0;
        $pelPembelajaranMendalam = $ringkasanPelatihan['Pembelajaran Mendalam'] ?? 0;

        $sekolahPerKabupaten = Sekolah::leftJoin('guru', 'guru.sekolah_id', '=', 'sekolah.id')
            ->select(
                'sekolah.kabupaten',
                DB::raw('COUNT(DISTINCT sekolah.id) as total_sekolah'),
                DB::raw('COUNT(guru.id) as total_guru')
            )
            ->groupBy('sekolah.kabupaten')
            ->orderBy('sekolah.kabupaten')
            ->get();

        return view('admin.dashboard', compact(
            'totalSekolah',
            'totalPtk',
            'totalPelatihan',
            'totalPeserta',
            'pelBk',
            'pelMat',
            'pelTendik',
            'pelPembelajaranMendalam',
            'sekolahPerKabupaten'
        ));
    }
}