<?php

namespace App\Http\Controllers;

use App\Models\SpdRincian;
use App\Models\Kuitansi;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class KeuanganUserController extends Controller
{
    public function index()
    {
        $guruId = auth()->user()->guru_id;

        $spd = SpdRincian::where('guru_id', $guruId)->latest()->get();
        $kuitansi = Kuitansi::where('guru_id', $guruId)->latest()->get();

        return view('user.keuangan.index', compact('spd', 'kuitansi'));
    }

    public function downloadSpd(SpdRincian $spd)
    {
        abort_if($spd->guru_id !== auth()->user()->guru_id, 403);

        $terbilang = \App\Support\Terbilang::make($spd->total);

        $pdf = Pdf::loadView('admin.keuangan.spd.print', compact('spd', 'terbilang'))
            ->setPaper('a4');

        return $pdf->download('rincian_spd_' . $spd->id . '.pdf');
    }

    public function downloadKuitansi(Kuitansi $kuitansi)
    {
        abort_if($kuitansi->guru_id !== auth()->user()->guru_id, 403);

        $pdf = Pdf::loadView('admin.keuangan.kuitansi.print', compact('kuitansi'))
            ->setPaper('a4');

        return $pdf->download('kuitansi_' . $kuitansi->id . '.pdf');
    }
}
