<?php

namespace App\Http\Controllers\Portal;

use App\Http\Controllers\Controller;
use App\Models\Guru;
use App\Models\Sekolah;
use App\Models\Pelatihan;
use App\Models\PelatihanPeserta;

class PortalController extends Controller
{
    public function index()
    {
        $lastUpdatedGuru = Guru::max('updated_at');
        $lastUpdatedSekolah = Sekolah::max('updated_at');
        $lastUpdatedPelatihan = Pelatihan::max('updated_at');

        $last = collect([$lastUpdatedGuru, $lastUpdatedSekolah, $lastUpdatedPelatihan])
            ->filter()
            ->sort()
            ->last();

        $stats = [
            'guru' => Guru::count(),
            'sekolah' => Sekolah::count(),
            'pelatihan' => Pelatihan::count(),
            'peserta_pelatihan' => PelatihanPeserta::count(),
            'last_updated' => $last
                ? \Illuminate\Support\Carbon::parse($last)->locale('id')->translatedFormat('d F Y H:i')
                : null,
        ];

        return view('portal.dashboard', compact('stats'));
    }
}
