<?php

namespace App\Imports;

use App\Models\RegistrasiPeserta;
use Maatwebsite\Excel\Concerns\ToModel;

class RegistrasiPesertaImport implements ToModel
{
    public function model(array $row)
    {
        /**
         * STRUKTUR KOLOM (WAJIB KONSISTEN)
         * 0  => nama_kegiatan
         * 1  => nama
         * 2  => nik
         * 3  => nip
         * ...
         */

        // 🔴 SKIP BARIS HEADER / KETERANGAN / KOSONG
        if (
            empty($row[1]) ||                       // nama kosong
            strtolower($row[1]) === 'nama' ||       // header
            str_contains(strtolower($row[0] ?? ''), 'keterangan')
        ) {
            return null;
        }

        return new RegistrasiPeserta([
            'pelatihan_id'       => null,                 // sementara null
            'nama_kegiatan'      => $row[0] ?? null,

            'nama'               => $row[1],              // WAJIB ADA
            'nik'                => $row[2] ?? null,
            'nip'                => $row[3] ?? null,
            'jabatan'            => $row[4] ?? null,
            'pangkat_golongan'   => $row[5] ?? null,
            'agama'              => $row[6] ?? null,
            'jenis_kelamin'      => $row[7] ?? null,
            'tempat_lahir'       => $row[8] ?? null,
            'tanggal_lahir'      => $row[9] ?? null,
            'no_hp'              => $row[10] ?? null,
            'email_pribadi'      => $row[11] ?? null,
            'pendidikan_terakhir'=> $row[12] ?? null,
            'prodi'              => $row[13] ?? null,
            'unit_kerja'         => $row[14] ?? null,
            'alamat_unit_kerja'  => $row[15] ?? null,
            'kab_kota_unit'      => $row[16] ?? null,
            'provinsi_unit'      => $row[17] ?? null,
            'kode_pos_unit'      => $row[18] ?? null,
            'telp_instansi'      => $row[19] ?? null,
            'alamat_rumah'       => $row[20] ?? null,
            'kab_kota_rumah'     => $row[21] ?? null,
            'provinsi_rumah'     => $row[22] ?? null,
            'kode_pos_rumah'     => $row[23] ?? null,
            'npwp'               => $row[24] ?? null,
            'no_rekening'        => $row[25] ?? null,
            'bank'               => $row[26] ?? null,
        ]);
    }
}
