<?php

namespace App\Imports;

use App\Models\Pelatihan;
use App\Models\SpdRincian;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Carbon\Carbon;

class SpdRincianImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        $currentNama  = null;
        $currentNip   = null;
        $currentTahun = null;

        $normalized = collect();

        foreach ($rows as $row) {

            // forward fill header
            if (!empty($row['nama'])) {
                $currentNama = trim($row['nama']);
                $currentNip  = null; // RESET NIP
            }

            if (!empty($row['nip'])) {
                $currentNip = trim($row['nip']);
            }


            if (!empty($row['tahun'])) {
                $currentTahun = $row['tahun'];
            }

            // skip kalau belum punya konteks SPD
            if (!$currentNama || !$currentTahun) {
                continue;
            }

            $row['nama']  = $currentNama;
            $row['nip']   = $currentNip;
            $row['tahun'] = $currentTahun;

            $normalized->push($row);
        }

        /**
         * GROUPING 1 ORANG = 1 SPD
         */
        $grouped = $normalized->groupBy(
            fn($r) =>
            $r['nama'] . '|' . ($r['nip'] ?? '-') . '|' . $r['tahun']
        );

        foreach ($grouped as $itemsRow) {

            $firstRow = $itemsRow[0];

            $items = [];
            $total = 0;

            foreach ($itemsRow as $row) {
                if (empty($row['uraian'])) continue;

                $qty   = (float) ($row['qty'] ?? 1);
                $harga = (float) ($row['harga'] ?? 0);

                $items[] = [
                    'uraian' => $row['uraian'],
                    'qty' => $qty,
                    'harga_satuan' => (int) $harga,
                    'keterangan'    => $row['keterangan'] ?? null,
                    'jumlah' => (int) round($qty * $harga),
                ];

                $total += round($qty * $harga);
            }

            if (count($items) === 0) continue;

            SpdRincian::create([
                'nama_ptk'       => $firstRow['nama'],
                'nip_ptk'        => $firstRow['nip'] ?? null,
                'tahun_anggaran' => $firstRow['tahun'],
                'bukti_kas_no'   => $firstRow['bukti_kas_no'] ?? null,
                'beban_mak'      => $firstRow['beban_mak'] ?? null,
                'lampiran_spd'   => $firstRow['lampiran_spd'] ?? null,
                'nomor_spd'      => $firstRow['nomor_spd'] ?? null,
                'tanggal_spd'    => $firstRow['tanggal_spd']
                    ? \Carbon\Carbon::parse($firstRow['tanggal_spd'])->format('Y-m-d')
                    : null,
                'items'          => $items,
                'total'          => $total,
                'created_by'     => auth()->id(),
            ]);
        }
    }
}
