<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Pegawai extends Model
{
    // Nama tabel (opsional, kalau sesuai konvensi Laravel 'pegawais' bisa dihilangkan)
    protected $table = 'pegawais';

    // Kolom yang boleh diisi mass assignment
    protected $fillable = [
        'nama',
        'nip',
        'gol',
        'pangkat_golongan',
        'jabatan',
        'status_kepegawaian',
        'instansi',
        'foto',
        'email',
        'telepon',
        'alamat',
        'tanggal_lahir',
        'jenis_kelamin',
    ];

    // Casting tipe data
    protected $casts = [
        'tanggal_lahir' => 'date',
    ];

    public function skAnggota()
    {
        return $this->hasMany(SkAnggota::class);
    }

}
