<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sekolah extends Model
{
    protected $table = 'sekolah';

    protected $fillable = [
        'sekolah_id', 'semester', 'npsn', 'nama', 'nama_nomenklatur',
        'bentuk_pendidikan', 'jenjang', 'alamat_jalan', 'nama_dusun',
        'desa_kelurahan', 'kecamatan', 'kabupaten', 'kode_pos',
        'nomor_telepon', 'email', 'kebutuhan_khusus', 'status_sekolah',
        'yayasan', 'keaktifan', 'partisipasi_bos', 'waktu_penyelenggaraan',
        'akses_internet', 'akreditasi', 'angkatan_psp',
    ];

    public function guru()
    {
        return $this->hasMany(Guru::class, 'sekolah_id', 'sekolah_id');
    }
}