<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SpdRincian extends Model
{
    protected $table = 'keuangan_spd_rincian';

    protected $fillable = [
        'ptk_type','ptk_id','nama_ptk', 'nip_ptk','pelatihan_id',
        'tahun_anggaran','bukti_kas_no','beban_mak',
        'lampiran_spd','nomor_spd','tanggal_spd',
        'items','total','created_by',
    ];

    protected $casts = [
        'items' => 'array',
        'tanggal_spd' => 'date',
    ];

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class);
    }

    public function ptk()
    {
        return $this->morphTo();
    }
}
