<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuratTugas extends Model
{
    protected $table = 'surat_tugas';

    protected $fillable = [
        'nama_kegiatan',
        'nomor_surat',
        'tanggal_surat',
        'tempat',
        'pejabat_penandatangan',
        'nip_penandatangan',
        'jabatan_penandatangan',
    ];

    public function anggota()
    {
        return $this->hasMany(SuratTugasPegawai::class); // ← SESUAIKAN
    }

    public function pegawai()
    {
        return $this->hasMany(SuratTugasPegawai::class);
    }

    public function kegiatan()
    {
        return $this->belongsTo(Kegiatan::class);
    }

    public function pegawais()
    {
        return $this->belongsToMany(
            Pegawai::class,
            'surat_tugas_pegawai'
        );
    }

    public function daftarHadir()
    {
        return $this->hasOne(DaftarHadir::class);
    }

}
