<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('role_id')->nullable()->after('id');
            $table->unsignedBigInteger('guru_id')->nullable()->after('role_id');

            $table->foreign('role_id')->references('id')->on('roles');
            $table->foreign('guru_id')->references('id')->on('guru');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['role_id']);
            $table->dropForeign(['guru_id']);
            $table->dropColumn(['role_id', 'guru_id']);
        });
    }
};
