<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('sekolah', function (Blueprint $table) {
            // RENAME KOLOM LAMA → BARU
            if (Schema::hasColumn('sekolah', 'dapodik_id')) {
                $table->renameColumn('dapodik_id', 'sekolah_id');
            }

            if (Schema::hasColumn('sekolah', 'nama_sekolah')) {
                $table->renameColumn('nama_sekolah', 'nama');
            }

            if (Schema::hasColumn('sekolah', 'alamat')) {
                $table->renameColumn('alamat', 'alamat_jalan');
            }

            if (Schema::hasColumn('sekolah', 'kab_kota')) {
                $table->renameColumn('kab_kota', 'kabupaten');
            }

            if (Schema::hasColumn('sekolah', 'status')) {
                $table->renameColumn('status', 'status_sekolah');
            }

            // TAMBAH KOLOM BARU, DIBUAT NULLABLE BIAR IMPORT AWAL NGGAK RIBUT
            if (!Schema::hasColumn('sekolah', 'semester')) {
                $table->string('semester')->nullable()->after('sekolah_id');
            }

            if (!Schema::hasColumn('sekolah', 'nama_nomenklatur')) {
                $table->string('nama_nomenklatur')->nullable()->after('nama');
            }

            if (!Schema::hasColumn('sekolah', 'bentuk_pendidikan')) {
                $table->string('bentuk_pendidikan')->nullable()->after('nama_nomenklatur');
            }

            if (!Schema::hasColumn('sekolah', 'nama_dusun')) {
                $table->string('nama_dusun')->nullable()->after('alamat_jalan');
            }

            if (!Schema::hasColumn('sekolah', 'desa_kelurahan')) {
                $table->string('desa_kelurahan')->nullable()->after('nama_dusun');
            }

            if (!Schema::hasColumn('sekolah', 'kode_pos')) {
                $table->string('kode_pos', 10)->nullable()->after('kabupaten');
            }

            if (!Schema::hasColumn('sekolah', 'nomor_telepon')) {
                $table->string('nomor_telepon', 50)->nullable()->after('kode_pos');
            }

            if (!Schema::hasColumn('sekolah', 'email')) {
                $table->string('email')->nullable()->after('nomor_telepon');
            }

            if (!Schema::hasColumn('sekolah', 'kebutuhan_khusus')) {
                $table->string('kebutuhan_khusus')->nullable()->after('email');
            }

            if (!Schema::hasColumn('sekolah', 'yayasan')) {
                $table->string('yayasan')->nullable()->after('status_sekolah');
            }

            if (!Schema::hasColumn('sekolah', 'keaktifan')) {
                $table->string('keaktifan')->nullable()->after('yayasan');
            }

            if (!Schema::hasColumn('sekolah', 'partisipasi_bos')) {
                $table->string('partisipasi_bos')->nullable()->after('keaktifan');
            }

            if (!Schema::hasColumn('sekolah', 'waktu_penyelenggaraan')) {
                $table->string('waktu_penyelenggaraan')->nullable()->after('partisipasi_bos');
            }

            if (!Schema::hasColumn('sekolah', 'akses_internet')) {
                $table->string('akses_internet')->nullable()->after('waktu_penyelenggaraan');
            }

            if (!Schema::hasColumn('sekolah', 'akreditasi')) {
                $table->string('akreditasi')->nullable()->after('akses_internet');
            }

            if (!Schema::hasColumn('sekolah', 'angkatan_psp')) {
                $table->string('angkatan_psp')->nullable()->after('akreditasi');
            }
        });
    }

    public function down(): void
    {
        // kalau dibutuhkan, bisa diisi reverse-nya, tapi untuk sekarang boleh dikosongkan
    }
};
