<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('registrasi_pelatihan', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('pelatihan_id')->nullable();
            $table->unsignedBigInteger('guru_id')->nullable();

            $table->string('nama_kegiatan')->nullable();

            // data peserta
            $table->string('nama')->nullable();
            $table->string('nik', 50)->nullable();
            $table->string('nip', 50)->nullable();
            $table->string('jabatan')->nullable();
            $table->string('pangkat_golongan')->nullable();
            $table->string('agama')->nullable();
            $table->string('jenis_kelamin', 20)->nullable();
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->string('no_hp', 50)->nullable();
            $table->string('email_pribadi')->nullable();
            $table->string('pendidikan_terakhir')->nullable();
            $table->string('prodi')->nullable();

            // unit kerja
            $table->string('unit_kerja')->nullable();
            $table->text('alamat_unit_kerja')->nullable();
            $table->string('kab_kota_unit')->nullable();
            $table->string('provinsi_unit')->nullable();
            $table->string('kode_pos_unit', 10)->nullable();
            $table->string('telp_instansi', 50)->nullable();

            // alamat rumah
            $table->text('alamat_rumah')->nullable();
            $table->string('kab_kota_rumah')->nullable();
            $table->string('provinsi_rumah')->nullable();
            $table->string('kode_pos_rumah', 10)->nullable();

            // pajak & bank
            $table->string('npwp', 50)->nullable();
            $table->string('nama_bank', 50)->nullable();
            $table->string('no_rekening', 50)->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('registrasi_pelatihan');
    }
};
