<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pelatihan_kelas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pelatihan_id')->constrained('pelatihan')->cascadeOnDelete();

            $table->string('kode_kelas', 10); // A/B/C/D
            $table->string('nama_kelas', 100); // contoh: Kelas A

            $table->foreignId('admin_lms_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('fasil_user_id')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();

            $table->unique(['pelatihan_id', 'kode_kelas']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pelatihan_kelas');
    }
};
