<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pelatihan_kelas_absensi_peserta', function (Blueprint $table) {
            $table->id();
            $table->foreignId('jadwal_id')->constrained('pelatihan_kelas_jadwal')->cascadeOnDelete();
            $table->foreignId('pelatihan_peserta_id')->constrained('pelatihan_peserta')->cascadeOnDelete();

            $table->enum('status', ['hadir', 'izin', 'sakit', 'alpa'])->default('hadir');
            $table->string('catatan')->nullable();

            $table->timestamps();

            $table->unique(['jadwal_id', 'pelatihan_peserta_id'], 'uq_abs_pes_jadwal_peserta');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pelatihan_kelas_absensi_peserta');
    }
};
