<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('daftar_hadir', function (Blueprint $table) {
            $table->id();
        
            $table->foreignId('surat_tugas_id')
                ->constrained('surat_tugas')
                ->cascadeOnDelete();
        
            $table->date('tanggal');
            $table->string('tempat');
        
            $table->timestamps();
        });
        
    }

    public function down(): void
    {
        Schema::dropIfExists('daftar_hadir');
    }
};
