<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('surat_tugas', function (Blueprint $table) {
            $table->string('nama_kegiatan')->after('id');
            $table->string('pejabat_penandatangan')->after('tanggal_surat');
            $table->string('nip_penandatangan')->nullable()->after('pejabat_penandatangan');
            $table->string('jabatan_penandatangan')->after('nip_penandatangan');
        });
    }

    public function down()
    {
        Schema::table('surat_tugas', function (Blueprint $table) {
            $table->dropColumn([
                'nama_kegiatan',
                'pejabat_penandatangan',
                'nip_penandatangan',
                'jabatan_penandatangan'
            ]);
        });
    }
};
