<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('daftar_hadir_detail', function (Blueprint $table) {
            if (!Schema::hasColumn('daftar_hadir_detail', 'tipe')) {
                $table->enum('tipe',['peserta','narasumber'])
                    ->default('peserta')
                    ->after('daftar_hadir_id');
            }

            if (!Schema::hasColumn('daftar_hadir_detail', 'nama_manual')) {
                $table->string('nama_manual')->nullable()->after('pegawai_id');
            }
        });
    }

    public function down()
    {
        Schema::table('daftar_hadir_detail', function (Blueprint $table) {
            if (Schema::hasColumn('daftar_hadir_detail', 'tipe')) {
                $table->dropColumn('tipe');
            }
            if (Schema::hasColumn('daftar_hadir_detail', 'nama_manual')) {
                $table->dropColumn('nama_manual');
            }
        });
    }

};
