<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        $role = Role::where('name', 'super_admin')->first();

        User::firstOrCreate(
            ['email' => 'admin@bgtk.local'],
            [
                'name' => 'Super Admin BGTK',
                'password' => Hash::make('password123'), // nanti ganti setelah login
                'role_id' => $role ? $role->id : null,
            ]
        );
    }
}
