@extends('layouts.admin')

@section('title', 'Data Guru DKI Jakarta - BGTK DKI')
@section('page_title', 'Data Guru / PTK DKI Jakarta')
@section('page_subtitle', 'Master data PTK, instansi, dan informasi pelatihan')

@section('content')

    {{-- Alert --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- ===========================
     CARD FILTER + TOOLBAR
    ============================ --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian & Filter Data Guru / PTK</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama, NIK, instansi, asal sekolah, kota, dan bidang bahasa.
                    </small>
                </div>

                {{-- Toolbar Import & Export --}}
                <div class="d-flex gap-2">
                    {{-- Export --}}
                    <a href="{{ route('guru.export') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-download me-1"></i> Export
                    </a>

                    {{-- Import (modal) --}}
                    <button type="button"
                            class="btn btn-primary btn-sm"
                            data-bs-toggle="modal"
                            data-bs-target="#modalImportGuru">
                        <i class="bi bi-upload me-1"></i> Import
                    </button>
                </div>
            </div>

            {{-- Tambah Data --}}
            <a href="{{ route('guru.create') }}" class="btn btn-success btn-sm mb-3">
                <i class="bi bi-plus-lg me-1"></i> Tambah Data
            </a>

            {{-- Form Filter --}}
            <form method="GET"
                action="{{ route('guru.index') }}"
                class="row g-2 align-items-end">

                <div class="col-12 col-md-4">
                    <label class="form-label small mb-1">Nama / NIK / Instansi</label>
                    <input type="text"
                        name="search"
                        value="{{ $search ?? '' }}"
                        class="form-control form-control-sm"
                        placeholder="Contoh: NIK, nama guru, atau nama instansi">
                </div>

                {{-- Kabupaten --}}
                <div class="col-6 col-md-3">
                    <label class="form-label form-label-sm mb-1 small">Kota</label>
                    <select name="kabupaten" class="form-select form-select-sm">
                        <option value="">Semua Kota</option>
                        @foreach($kabupatenOptions as $kab)
                            <option value="{{ $kab }}" {{ ($kabupaten ?? '') == $kab ? 'selected' : '' }}>
                                {{ $kab }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Bidang Bahasa --}}
                <div class="col-6 col-md-3">
                    <label class="form-label small mb-1">Bidang Bahasa</label>
                    <select name="bidang_bahasa_id"
                            class="form-select form-select-sm">
                        <option value="">Semua bidang</option>
                        @foreach($bidangList as $bidang)
                            <option value="{{ $bidang->id }}"
                                {{ ($bidangId ?? '') == $bidang->id ? 'selected' : '' }}>
                                {{ $bidang->nama_bahasa }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-12 col-md-2 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('guru.index') }}"
                    class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>

            </form>
        </div>
    </div>

    {{-- ===========================
     TABLE DATA GURU / PTK
============================ --}}
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">Daftar Guru / PTK</h6>
            @if(method_exists($guru, 'total'))
                <small class="text-muted">
                    Menampilkan {{ $guru->total() }} data
                    ({{ $guru->firstItem() ?? 0 }} - {{ $guru->lastItem() ?? 0 }})
                </small>
            @endif
        </div>

        <div class="table-responsive mt-2">
            <table class="table table-sm table-hover align-middle">
                <thead class="table-light small text-uppercase">
                    <tr>
                        <th class="text-center">Nama & Identitas</th>
                        <th class="text-center">Sekolah / Kota</th>
                        <th class="text-center">TTL & Agama</th>
                        <th class="text-center">Kontak</th>
                        <th class="text-center">Pangkat / Golongan</th>
                        <th class="text-center" style="width: 90px;">Aksi</th>
                    </tr>
                </thead>

                <tbody class="small">
                    @forelse($guru as $g)
                        <tr>
                            {{-- Nama + NIP/NUPTK/NIK --}}
                            <td>
                                <div class="fw-semibold">
                                    {{ $g->nama_guru ?? '-' }}
                                </div>
                                <div class="text-muted" style="font-size: 11px;">
                                    NIP: {{ $g->nip ?? '-' }}<br>
                                    NUPTK: {{ $g->nuptk ?? '-' }}<br>
                                    NIK: {{ $g->nik ?? '-' }}
                                </div>
                            </td>

                            {{-- Sekolah + Kota (via relasi sekolah kalau ada) --}}
                            <td>
                                <div class="fw-semibold">
                                    {{ optional($g->sekolah)->nama ?? '-' }}
                                </div>
                                <div class="text-muted" style="font-size: 11px;">
                                    Kota: {{ optional($g->sekolah)->kabupaten ?? '-' }}<br>
                                    ID Sekolah: {{ $g->sekolah_id ?? '-' }}
                                </div>
                            </td>

                            {{-- Tempat / Tanggal lahir + Agama --}}
                            <td>
                                <div>
                                    {{ $g->tempat_lahir ?? '-' }},
                                    @if(!empty($g->tanggal_lahir))
                                        {{ \Carbon\Carbon::parse($g->tanggal_lahir)->format('d-m-Y') }}
                                    @else
                                        -
                                    @endif
                                </div>
                                <div class="text-muted" style="font-size: 11px;">
                                    Agama: {{ $g->agama ?? '-' }}
                                </div>
                            </td>

                            {{-- Kontak --}}
                            <td>
                                <div class="text-truncate" style="max-width: 180px;">
                                    {{ $g->email ?? '-' }}
                                </div>
                                <div class="text-muted" style="font-size: 11px;">
                                    No. HP: {{ $g->no_hp ?? '-' }}
                                </div>
                            </td>

                            {{-- Pangkat / Golongan --}}
                            <td>
                                {{ $g->pangkat_golongan ?? '-' }}
                            </td>
                            
                            
                            <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('guru.show', $g) }}">
                                                    <i class="bi bi-eye me-2 text-info"></i> Detail
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('guru.edit', $g) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>

                                            <li>
                                                <form action="{{ route('guru.destroy', $g) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data guru ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>

                            
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                Belum ada data guru / PTK. Silakan import dari file Excel atau tambah data manual.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- PAGINASI --}}
        @if(method_exists($guru, 'links'))
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3 small text-muted gap-2">
                <div>
                    Menampilkan {{ $guru->firstItem() ?? 0 }} - {{ $guru->lastItem() ?? 0 }}
                    dari {{ $guru->total() }} data
                </div>
                <div>
                    {{ $guru->onEachSide(1)->links() }}
                </div>
            </div>
        @endif
    </div>
</div>

{{-- MODAL IMPORT GURU --}}
<div class="modal fade" id="modalImportGuru" tabindex="-1" aria-labelledby="modalImportGuruLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="{{ route('guru.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h6 class="modal-title" id="modalImportGuruLabel">Import Data</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="small text-muted mb-2">
                        Gunakan template Excel resmi (Data PTK) yang berisi kolom NIK, nama, NIP, instansi,
                        pangkat, pendidikan, NPWP, dan nomor rekening.
                    </p>
                    <div class="mb-2">
                        <label class="form-label small">File Excel (.xlsx / .xls)</label>
                        <input type="file" name="file"
                               class="form-control form-control-sm"
                               accept=".xlsx,.xls"
                               required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button"
                            class="btn btn-outline-secondary btn-sm"
                            data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit"
                            class="btn btn-primary btn-sm">
                        Import
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
