@extends('layouts.admin')

@section('content')
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h5 class="mb-0 fw-bold">Jadwal Kelas</h5>
      <small class="text-muted">
        {{ $kelas->pelatihan->nama_pelatihan }} ({{ $kelas->nama_kelas }})
      </small>
    </div>

    <a href="{{ route('admin.kelas.jadwal.create', $kelas->id) }}" class="btn btn-primary">
      + Tambah Jadwal
    </a>
  </div>

  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif

  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered align-middle">
          <thead>
            <tr>
              <th>Tanggal</th>
              <th>Jam</th>
              <th>Mapel</th>
              <th>Tempat</th>
              <th width="160">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse($jadwals as $j)
              <tr>
                <td>{{ $j->tanggal }}</td>
                <td>{{ $j->jam_mulai }} - {{ $j->jam_selesai }}</td>
                <td>{{ $j->mapel }}</td>
                <td>{{ $j->tempat ?? '-' }}</td>
                <td>
                  <a href="{{ route('admin.kelas.jadwal.edit', [$kelas->id, $j->id]) }}" class="btn btn-sm btn-warning">
                    Edit
                  </a>

                  <form action="{{ route('admin.kelas.jadwal.destroy', [$kelas->id, $j->id]) }}"
                        method="POST"
                        class="d-inline"
                        onsubmit="return confirm('Yakin hapus jadwal ini?')">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-sm btn-danger">Hapus</button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center text-muted">Belum ada jadwal.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection
