@extends('layouts.admin')

@section('page_title','Edit Daftar Hadir Peserta')

@section('content')
<div class="card">
    <div class="card-body">

        <form method="POST"
              action="{{ route('daftar-hadir.update', $daftarHadir->id) }}">
            @csrf
            @method('PUT')

            {{-- INFO KEGIATAN --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Kegiatan</label>
                <input type="text"
                       class="form-control"
                       value="{{ $daftarHadir->suratTugas->nama_kegiatan }}"
                       disabled>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tanggal</label>
                    <input type="date"
                           name="tanggal"
                           class="form-control"
                           value="{{ $daftarHadir->tanggal }}"
                           required>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tempat</label>
                    <input type="text"
                           name="tempat"
                           class="form-control"
                           value="{{ $daftarHadir->tempat }}"
                           required>
                </div>
            </div>

            <hr>

            {{-- PESERTA MANUAL --}}
            <h6 class="fw-bold mb-2">Peserta Manual</h6>

            <div id="manual-wrapper">

                {{-- MANUAL EXISTING --}}
                @foreach($daftarHadir->detail->whereNull('pegawai_id') as $d)
                    <div class="input-group mb-2 manual-row">
                        <input type="text"
                               name="manual_existing[{{ $d->id }}]"
                               class="form-control"
                               value="{{ $d->nama_manual }}"
                               required>

                        <button type="button"
                                class="btn btn-outline-danger btn-remove">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                @endforeach

            </div>

            {{-- TAMBAH BARU --}}
            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Peserta Manual
            </button>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Perubahan
                </button>

                <a href="{{ route('daftar-hadir.index') }}"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const wrapper = document.getElementById('manual-wrapper');
    const btnAdd  = document.getElementById('btn-add');

    btnAdd.addEventListener('click', function () {
        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','manual-row');

        row.innerHTML = `
            <input type="text"
                   name="manual_new[]"
                   class="form-control"
                   placeholder="Nama peserta manual"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove">
                <i class="bi bi-trash"></i>
            </button>
        `;

        wrapper.appendChild(row);
    });

    wrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove')) {
            e.target.closest('.manual-row').remove();
        }
    });

});
</script>
@endpush
