@extends('layouts.admin')

@section('page_title','Daftar Hadir')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Daftar Hadir Kegiatan</h5>

        <a href="{{ route('daftar-hadir.create') }}"
           class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle"></i> Tambah Daftar Hadir
        </a>
    </div>

    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th width="40">No</th>
                    <th>Kegiatan</th>
                    <th>Tanggal</th>
                    <th>Peserta</th>
                    <th>Narasumber</th>
                    <th width="170">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($data as $i => $row)
                <tr>
                    <td>{{ $i + 1 }}</td>

                    <td>
                        {{ $row->suratTugas->nama_kegiatan ?? '-' }}
                    </td>

                    <td>
                        {{ \Carbon\Carbon::parse($row->tanggal)->translatedFormat('d F Y') }}
                    </td>

                    <td class="text-center">
                        {{ $row->detail->where('tipe','peserta')->count() }} orang
                    </td>

                    <td class="text-center">
                        {{ $row->detail->where('tipe','narasumber')->count() }} orang
                    </td>

                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                    data-bs-toggle="dropdown">
                                <i class="bi bi-three-dots-vertical"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-end small shadow">

                                {{-- CETAK --}}
                                <li>
                                    <a class="dropdown-item"
                                       href="{{ route('daftar-hadir.cetak',$row->id) }}"
                                       target="_blank">
                                        <i class="bi bi-eye me-2 text-primary"></i>
                                        Lihat / Cetak
                                    </a>
                                </li>

                                {{-- KELOLA PESERTA --}}
                                <li>
                                    <a class="dropdown-item"
                                       href="{{ route('daftar-hadir.edit',$row->id) }}">
                                        <i class="bi bi-people me-2 text-success"></i>
                                        Kelola Peserta
                                    </a>
                                </li>

                                {{-- KELOLA NARASUMBER --}}
                                <li>
                                    <a class="dropdown-item"
                                       href="{{ route('daftar-hadir-narasumber.index',$row->id) }}">
                                        <i class="bi bi-mic me-2 text-info"></i>
                                        Kelola Narasumber
                                    </a>
                                </li>

                                <li><hr class="dropdown-divider"></li>

                                {{-- HAPUS --}}
                                <li>
                                    <form action="{{ route('daftar-hadir.destroy',$row->id) }}"
                                          method="POST"
                                          onsubmit="return confirm('Yakin hapus daftar hadir ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="dropdown-item text-danger">
                                            <i class="bi bi-trash me-2"></i>
                                            Hapus
                                        </button>
                                    </form>
                                </li>

                            </ul>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center text-muted">
                        Belum ada data daftar hadir
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
