@extends('layouts.admin')

@section('title', 'Kuitansi - BGTK DKI')
@section('page_title', 'Administrasi Keuangan - Kuitansi')
@section('page_subtitle', 'Kelola kuitansi honor/perintah pembayaran per PTK')

@section('content')

    {{-- Alert --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- CARD FILTER + TOOLBAR --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian Kuitansi</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama PTK, NIP, atau NUPTK.
                    </small>
                </div>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.keuangan.kuitansi.create') }}" class="btn btn-success btn-sm">
                        <i class="bi bi-plus-lg me-1"></i> Tambah Kuitansi
                    </a>
                </div>
            </div>

            <form method="GET" action="{{ route('admin.keuangan.kuitansi.index') }}" class="row g-2 align-items-end">

                <div class="col-12 col-md-6">
                    <label class="form-label small mb-1">Nama / NIP / NUPTK</label>
                    <input type="text" name="search" value="{{ $search ?? '' }}" class="form-control form-control-sm"
                        placeholder="Contoh: Dr. Nahdiana, 1969..., 12345...">
                </div>

                <div class="col-12 col-md-3">
                    <label class="form-label small mb-1">Tahun Anggaran</label>
                    <input type="text" name="tahun" value="{{ $tahun ?? '' }}" class="form-control form-control-sm"
                        placeholder="2025">
                </div>

                <div class="col-12 col-md-3 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('admin.keuangan.kuitansi.index') }}"
                        class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    {{-- TABLE KUITANSI --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Kuitansi</h6>

                @if(isset($rows) && method_exists($rows, 'total'))
                    <small class="text-muted">
                        Menampilkan {{ $rows->total() }} data
                        ({{ $rows->firstItem() ?? 0 }} - {{ $rows->lastItem() ?? 0 }})
                    </small>
                @endif
                {{-- Tombol Download ZIP --}}
                <a href="{{ route('admin.keuangan.kuitansi.downloadAll') }}" class="btn btn-sm btn-dark">
                    <i class="bi bi-archive me-1"></i> Download Semua Kuitansi
                </a>
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>PTK</th>
                            <th>Pelatihan</th>
                            <th class="text-center">Tahun</th>
                            <th>Bukti Kas</th>
                            <th class="text-end">Honor</th>
                            <th class="text-end">PPH21</th>
                            <th class="text-end">Diterima</th>
                            <th class="text-center">Tanggal</th>
                            <th class="text-center" style="width: 160px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">
                        @forelse($rows as $r)
                            <tr>
                                <td>
                                    <div class="fw-semibold">
                                        {{ $r->ptk->nama_guru ?? $r->ptk->nama ?? '-' }}
                                    </div>

                                    <div class="text-muted" style="font-size: 11px;">
                                        NIP: {{ $r->ptk->nip ?? '-' }} <br>

                                        @if(isset($r->ptk->nuptk))
                                            NUPTK: {{ $r->ptk->nuptk }}
                                        @endif
                                    </div>
                                </td>

                                </td>
                                <td>
                                    {{ $r->pelatihan->nama_pelatihan ?? '-' }}
                                </td>
                                <td class="text-center">
                                    {{ $r->tahun_anggaran ?? '-' }}
                                </td>
                                <td>
                                    {{ $r->bukti_kas_no ?? '-' }}
                                </td>
                                <td class="text-end">
                                    Rp {{ number_format($r->honor_bruto ?? 0, 0, ',', '.') }}
                                </td>
                                <td class="text-end">
                                    Rp {{ number_format($r->pph21_amount ?? 0, 0, ',', '.') }}
                                </td>
                                <td class="text-end fw-semibold">
                                    Rp {{ number_format($r->jumlah_diterima ?? 0, 0, ',', '.') }}
                                </td>
                                <td class="text-center">
                                    {{ optional($r->tanggal_kuitansi)->format('d-m-Y') ?? '-' }}
                                </td>


                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('admin.keuangan.kuitansi.show', $r->id) }}">
                                                    <i class="bi bi-eye me-2 text-primary"></i> Detail
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('admin.keuangan.kuitansi.edit', $r->id) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item" target="_blank"
                                                    href="{{ route('admin.keuangan.kuitansi.print', $r->id) }}">
                                                    <i class="bi bi-printer me-2 text-secondary"></i> Print
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('admin.keuangan.kuitansi.download', $r->id) }}">
                                                    <i class="bi bi-download me-2 text-success"></i> Download PDF
                                                </a>
                                            </li>

                                            <li>
                                                <form action="{{ route('admin.keuangan.kuitansi.destroy', $r->id) }}"
                                                    method="POST"
                                                    onsubmit="return confirm('Yakin ingin menghapus data kuitansi ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>

                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center text-muted py-4">
                                    Belum ada data kuitansi.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if(isset($rows) && method_exists($rows, 'links'))
                <div class="mt-3">
                    {{ $rows->links() }}
                </div>
            @endif

        </div>
    </div>

@endsection