@php
    // ✅ tanggal ikut input create (kolom: tanggal_kuitansi)
    $tglSource = $kuitansi->tanggal_kuitansi ?? $kuitansi->created_at;
    $tglCetak = \Carbon\Carbon::parse($tglSource)->locale('id')->translatedFormat('d F Y');

    $kopPath = public_path('images/kop_bgtk_terbaru.png');
    $kopSrc = asset('images/kop_bgtk_terbaru.png');

    if (file_exists($kopPath)) {
        $type = pathinfo($kopPath, PATHINFO_EXTENSION);
        $data = base64_encode(file_get_contents($kopPath));
        $kopSrc = "data:image/{$type};base64,{$data}";
    }
@endphp

<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Kuitansi</title>

    <style>
        @page {
            size: A4;
            margin: 15mm 14mm;
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #111;
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
        }

        .header img {
            width: 100%;
            display: block;
        }

        .content {
            padding: 18px 18px;
        }

        .small {
            font-size: 11px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .tbl,
        .tbl th,
        .tbl td {
            border: 1px solid #000;
        }

        .tbl th,
        .tbl td {
            padding: 6px;
            vertical-align: top;
        }

        .no-border,
        .no-border td {
            border: none !important;
        }

        .right-box {
            border: 1px solid #000;
            padding: 6px;
        }

        .ttd-space {
            height: 46px;
        }
    </style>
</head>

<body>
    {{-- KOP --}}
    <div class="header">
        <img src="{{ $kopSrc }}" alt="Kop Surat">
    </div>

    <div class="content">

        {{-- BAGIAN ATAS --}}
        <table class="tbl">
            <tr>
                <td style="width:55%; border-right:1px solid #000;">
                    <table class="no-border">
                        <tr>
                            <td class="no-border" style="width:160px;">Tahun Anggaran</td>
                            <td class="no-border" style="width:10px;">:</td>
                            <td class="no-border">{{ $kuitansi->tahun_anggaran }}</td>
                        </tr>
                        <tr>
                            <td class="no-border">Bukti Kas No.</td>
                            <td class="no-border">:</td>
                            <td class="no-border">{{ $kuitansi->bukti_kas_no }}</td>
                        </tr>
                        <tr>
                            <td class="no-border">Beban</td>
                            <td class="no-border">:</td>
                            <td class="no-border">{{ $kuitansi->beban }}</td>
                        </tr>
                        <tr>
                            <td class="no-border">Akun</td>
                            <td class="no-border">:</td>
                            <td class="no-border">{{ $kuitansi->akun }}</td>
                        </tr>
                    </table>
                </td>
                <td style="width:45%; text-align:center; vertical-align:middle;">
                    <div style="font-size:22px; font-weight:700; letter-spacing:6px;">KUITANSI</div>
                </td>
            </tr>
        </table>

        {{-- DATA UTAMA --}}
        <table class="tbl" style="margin-top:10px;">
            <tr>
                <td style="width:70%; border-right:1px solid #000;">
                    <table class="no-border">
                        <tr>
                            <td class="no-border" style="width:160px;"><strong>SUDAH TERIMA DARI</strong></td>
                            <td class="no-border" style="width:10px;">:</td>
                            <td class="no-border">{{ $kuitansi->sudah_terima_dari }}</td>
                        </tr>
                        <tr>
                            <td class="no-border"><strong>BANYAKNYA UANG</strong></td>
                            <td class="no-border">:</td>
                            <td class="no-border">
                                <div class="right-box">
                                    Rp. {{ number_format($kuitansi->honor_bruto + $kuitansi->transport_total) }},-
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="no-border"><strong>UNTUK PEMBAYARAN</strong></td>
                            <td class="no-border">:</td>
                            <td class="no-border">{{ $kuitansi->untuk_pembayaran }}</td>
                        </tr>
                        <tr>
                            <td class="no-border"><strong>TERBILANG</strong></td>
                            <td class="no-border">:</td>
                            <td class="no-border">## {{ ucwords($kuitansi->terbilang) }} rupiah ##</td>
                        </tr>
                    </table>
                </td>

                <td style="width:30%;">
                    <div class="right-box">
                        <table class="no-border">
                            <tr>
                                <td class="no-border">Transport Lokal</td>
                                <td class="no-border" style="text-align:right;">
                                    {{ number_format($kuitansi->honor_bruto + $kuitansi->transport_total) }}
                                </td>
                            </tr>
                            <tr>
                                <td class="no-border">PPH 21</td>
                                <td class="no-border" style="text-align:right;">
                                    {{ number_format($kuitansi->pph21_amount, 0, ',', '.') }}
                                </td>
                            </tr>
                            <tr>
                                <td class="no-border"><strong>Jumlah Diterima</strong></td>
                                <td class="no-border" style="text-align:right;">
                                    <strong>{{ number_format($kuitansi->jumlah_diterima, 0, ',', '.') }}</strong>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
        </table>

        {{-- TANDA TANGAN --}}
        <table class="tbl" style="margin-top:14px;">
            <tr>
                <td style="width:33%;">
                    <div class="small">
                        Setuju dibebankan pada Mata Anggaran berkenaan. An. KPA<br>
                        Pejabat Pembuat Komitmen,
                    </div>
                    <div class="ttd-space"></div><br><br>
                    <strong>Dudi Ruhyadi Muharam, S.Si., M.Si</strong><br>
                    <span class="small">NIP. 197712112005011004</span>
                </td>

                <td style="width:33%;">
                    <div class="small">
                        Lunas dibayar tanggal {{ $tglCetak }}<br>
                        Bendahara Pengeluaran,
                    </div>
                    <div class="ttd-space"></div><br><br>
                    <strong>Sultan Takdir Ali Sahbana</strong><br>
                    <span class="small">NIP. 198603182018011001</span>
                </td>

                <td style="width:34%;">
                    <div class="small">
                        Jakarta, {{ $tglCetak }}<br>
                        Yang Menerima Uang,
                    </div>
                    <div class="ttd-space"></div><br><br><br>
                    <strong>
                        {{ $kuitansi->ptk?->nama_guru ?? $kuitansi->ptk?->nama ?? '-' }}
                    </strong><br>

                    <span class="small">
                        NIP/NUPTK:
                        {{ $kuitansi->ptk?->nip ?? $kuitansi->ptk?->nuptk ?? '-' }}
                    </span>

                </td>
            </tr>
        </table>

    </div>
</body>

</html>