@extends('layouts.admin')

@section('title', 'Tambah Rincian SPD')
@section('page_title', 'Tambah Rincian SPD')
@section('page_subtitle', 'Input rincian biaya perjalanan dinas per PTK')

@section('content')
    @if($errors->any())
        <div class="alert alert-danger small">
            <strong>Terjadi kesalahan:</strong>
            <ul class="mb-0 mt-1">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.keuangan.spd.store') }}" method="POST">
        @csrf
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <h6 class="mb-3">Informasi Umum</h6>

                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">PTK / Guru</label>
                        <select name="ptk" id="ptk" class="form-select form-select-sm js-ptk-select"
                            data-placeholder="Cari PTK / Guru" required>
                            <option value="">-- pilih PTK --</option>

                            @if(isset($selectedGuru) && $selectedGuru)
                                <option value="guru_{{ $selectedGuru->id }}" selected>
                                    {{ $selectedGuru->nama_guru }}
                                    @if($selectedGuru->nip) - ({{ $selectedGuru->nip }}) @endif
                                </option>
                            @endif
                        </select>
                        <small class="text-muted">
                            Ketik nama / NIP / NUPTK untuk mencari PTK.
                        </small>

                    </div>

                    <div class="col-md-4">
                        <label class="form-label small">Pelatihan</label>
                        <select name="pelatihan_id" class="form-select form-select-sm">
                            <option value="">-- opsional --</option>
                            @foreach($pelatihanList as $p)
                                <option value="{{ $p->id }}" {{ old('pelatihan_id') == $p->id ? 'selected' : '' }}>
                                    {{ $p->nama_pelatihan }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Tahun Anggaran</label>
                        <input type="text" name="tahun_anggaran" value="{{ old('tahun_anggaran', date('Y')) }}"
                            class="form-control form-control-sm" required>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Tanggal SPD</label>
                        <input type="date" name="tanggal_spd" value="{{ old('tanggal_spd') }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label small">Beban MAK</label>
                        <input type="text" name="beban_mak" value="{{ old('beban_mak') }}"
                            class="form-control form-control-sm" placeholder="contoh: 054.01.FK....">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label small">Bukti Kas No.</label>
                        <input type="text" name="bukti_kas_no" value="{{ old('bukti_kas_no') }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Lampiran SPD</label>
                        <input type="text" name="lampiran_spd" value="{{ old('lampiran_spd') }}"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label small">Nomor SPD</label>
                        <input type="text" name="nomor_spd" value="{{ old('nomor_spd') }}"
                            class="form-control form-control-sm">
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="mb-0">Rincian Biaya</h6>
                    <button type="button" class="btn btn-outline-primary btn-sm" id="btnAddRow">
                        <i class="bi bi-plus-lg me-1"></i> Tambah Baris
                    </button>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle" id="tblItems">
                        <thead class="table-light small text-uppercase">
                            <tr>
                                <th style="width:35%;">Perincian Biaya</th>
                                <th style="width:10%;">Qty</th>
                                <th style="width:20%;">Harga Satuan (Rp)</th>
                                <th style="width:20%;">Keterangan</th>
                                <th style="width:5%;"></th>
                            </tr>
                        </thead>
                        <tbody class="small">
                            @php
                                $oldItems = old('uraian', ['']);
                            @endphp

                            @foreach($oldItems as $i => $oldUraian)
                                <tr>
                                    <td>
                                        <textarea name="uraian[]" rows="3"
                                            class="form-control form-control-sm">{{ $oldUraian }}</textarea>
                                    </td>
                                    <td>
                                        <input type="number" name="qty[]" class="form-control form-control-sm"
                                            value="{{ old('qty.' . $i, 1) }}" min="1">
                                    </td>
                                    <td>
                                        <input type="number" name="harga_satuan[]" class="form-control form-control-sm"
                                            value="{{ old('harga_satuan.' . $i) }}" min="0">
                                    </td>
                                    <td>
                                        <textarea name="keterangan_item[]" rows="3"
                                            class="form-control form-control-sm">{{ old('keterangan_item.' . $i) }}</textarea>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-outline-danger btn-sm btn-remove-row">
                                            <i class="bi bi-x-lg"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <small class="text-muted">
                    Jika tidak diperlukan, baris bisa dikosongkan atau dihapus.
                </small>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.keuangan.spd.index') }}" class="btn btn-outline-secondary">
                Kembali
            </a>
            <button type="submit" class="btn btn-primary">
                Simpan Rincian SPD
            </button>
        </div>
    </form>

    <template id="tpl-row">
        <tr>
            <td>
                <textarea name="uraian[]" rows="3" class="form-control form-control-sm"></textarea>
            </td>
            <td>
                <input type="number" name="qty[]" class="form-control form-control-sm" value="1" min="1">
            </td>
            <td>
                <input type="number" name="harga_satuan[]" class="form-control form-control-sm" value="0" min="0">
            </td>
            <td>
                <textarea name="keterangan_item[]" rows="3" class="form-control form-control-sm"></textarea>
                {{-- <input type="text" name="keterangan_item[]" class="form-control form-control-sm"> --}}
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-outline-danger btn-sm btn-remove-row">
                    <i class="bi bi-x-lg"></i>
                </button>
            </td>
        </tr>
    </template>

@endsection

@push('scripts')
    <script>
        $(document).ready(function () {

            // --- SELECT2 GURU ---
            $('#ptk').select2({
                theme: 'bootstrap-5',
                placeholder: 'Cari PTK (Guru / Pegawai)',
                ajax: {
                    url: "{{ route('ptk.select2') }}",
                    dataType: 'json',
                    delay: 250,
                    data: params => ({ q: params.term }),
                    processResults: data => data
                }
            });

            // --- TAMBAH BARIS ---
            $('#btnAddRow').on('click', function () {
                let tpl = $('#tpl-row').html();
                $('#tblItems tbody').append(tpl);
            });

            // --- HAPUS BARIS ---
            $(document).on('click', '.btn-remove-row', function () {
                $(this).closest('tr').remove();
            });
        });

        $(document).on('keydown', 'textarea[name="uraian[]"]', function (e) {
            if (e.key === 'Tab') {
                e.preventDefault();

                let start = this.selectionStart;
                let end = this.selectionEnd;

                // sisipkan 4 spasi (atau "\t" kalau mau tab asli)
                this.value =
                    this.value.substring(0, start) +
                    '    ' +
                    this.value.substring(end);

                this.selectionStart = this.selectionEnd = start + 4;
            }
        });
        
    </script>

@endpush