@extends('layouts.admin')

@section('title', 'Detail Rincian SPD')
@section('page_title', 'Detail Rincian SPD')
@section('page_subtitle', 'Pratinjau rincian biaya perjalanan dinas')

@section('content')

@php
    \Carbon\Carbon::setLocale('id');
@endphp

{{-- ACTION BUTTON --}}
<div class="d-flex justify-content-between align-items-center mb-3 no-print">
    <a href="{{ route('admin.keuangan.spd.index') }}" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>

    <div class="btn-group btn-group-sm">
        <a href="{{ route('admin.keuangan.spd.print', $spd->id) }}" target="_blank" class="btn btn-outline-secondary">
            <i class="bi bi-printer"></i> Print
        </a>
        <a href="{{ route('admin.keuangan.spd.download', $spd->id) }}" class="btn btn-primary">
            <i class="bi bi-download"></i> Download PDF
        </a>
    </div>
</div>

{{-- PREVIEW WRAPPER --}}
<div class="card border-0 shadow-sm">
    <div class="card-body p-0">

<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Rincian Biaya Perjalanan Dinas</title>

    <style>
        @page { margin: 0; }

        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 12px;
            color: #111;
            margin: 0;
            background: #e9ecef;
        }

        .preview-wrapper {
            background: #e9ecef;
            padding: 30px 0;
        }

        .page {
            background: #fff;
            width: 210mm;
            margin: 0 auto;
        }

        .header img {
            width: 100%;
            display: block;
        }

        .content {
            padding: 0 20px 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .tbl, .tbl th, .tbl td {
            border: 1px solid #000;
        }

        .tbl th, .tbl td {
            padding: 6px;
            vertical-align: top;
        }

        .box-right {
            border: 1px solid #000;
            padding: 6px;
            width: 40%;
            float: right;
            margin-top: 5px;
        }

        .clear { clear: both; }

        .small { font-size: 11px; }

        .sign td {
            border: none !important;
        }

        @media print {
            .no-print { display: none !important; }
            body { background: #fff; }
        }

        .uraian-text {
            white-space: pre-wrap;
            line-height: 1.3;
        }

        .keterangan-text {
            white-space: pre-wrap;
            line-height: 1.3;
        }
    </style>
</head>

<body>
<div class="preview-wrapper">
<div class="page">

    {{-- KOP --}}
    <div class="header">
        <img src="{{ asset('images/kop_bgtk_terbaru.png') }}" alt="Kop Surat">
    </div>

    <div class="content">

        {{-- BOX KANAN --}}
        <div class="box-right">
            <table style="border:none;">
                <tr>
                    <td style="border:none;">Beban MAK</td>
                    <td style="border:none;">:</td>
                    <td style="border:none;">{{ $spd->beban_mak }}</td>
                </tr>
                <tr>
                    <td style="border:none;">Bukti Kas No</td>
                    <td style="border:none;">:</td>
                    <td style="border:none;">{{ $spd->bukti_kas_no }}</td>
                </tr>
                <tr>
                    <td style="border:none;">Tahun Anggaran</td>
                    <td style="border:none;">:</td>
                    <td style="border:none;">{{ $spd->tahun_anggaran }}</td>
                </tr>
            </table>
        </div>

        {{-- JUDUL --}}
        <div class="clear" style="margin-top:10px; text-align:center;">
            <strong style="font-size:14px; display:block; margin:10px 0 15px;">
                RINCIAN BIAYA PERJALANAN DINAS
            </strong>

            <table style="width:50%; text-align:left;">
                <tr>
                    <td>Lampiran SPD</td>
                    <td>:</td>
                    <td>{{ $spd->lampiran_spd }}</td>
                </tr>
                <tr>
                    <td>Nomor</td>
                    <td>:</td>
                    <td>{{ $spd->nomor_spd }}</td>
                </tr>
                <tr>
                    <td>Tanggal</td>
                    <td>:</td>
                    <td>{{ optional($spd->tanggal_spd)->translatedFormat('d F Y') }}</td>
                </tr>
            </table>
        </div>

        {{-- TABEL RINCIAN --}}
        <table class="tbl" style="margin-top:10px;">
            <thead>
                <tr>
                    <th style="width:5%;">No</th>
                    <th>Perincian Biaya</th>
                    <th style="width:20%;">Jumlah (Rp)</th>
                    <th style="width:20%;">Keterangan</th>
                </tr>
            </thead>
            <tbody>
                @foreach($spd->items as $i => $it)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td class="uraian-text">{{ $it['uraian'] }}</td>
                    <td style="text-align:right;">
                        {{ number_format($it['jumlah'], 0, ',', '.') }}
                    </td>
                    <td class="keterangan-text">{{ $it['keterangan'] ?? '-' }}</td>
                </tr>
                @endforeach

                <tr>
                    <td colspan="2" style="text-align:center;"><strong>Jumlah</strong></td>
                    <td style="text-align:right;">
                        <strong>{{ number_format($spd->total, 0, ',', '.') }}</strong>
                    </td>
                    <td></td>
                </tr>

                <tr>
                    <td colspan="4">
                        <strong>Terbilang :</strong>
                        ## {{ ucwords($terbilang) }} rupiah ##
                    </td>
                </tr>
            </tbody>
        </table>

        {{-- TANDA TANGAN --}}
        <table class="sign" style="margin-top:20px;">
            <tr>
                <td style="width:50%;">
                    <div>Telah dibayar sejumlah</div>
                    <div>Rp. {{ number_format($spd->total, 0, ',', '.') }}</div>
                    <div>Bendahara Pengeluaran</div>
                    <br><br><br><br>
                    <strong>Immaculata Heni Herawati</strong><br>
                    <span class="small">NIP. 198712182020122008</span>
                </td>

                <td style="width:50%; padding-left:95px;">
                    <div>
                        Jakarta, {{ optional($spd->tanggal_spd)->translatedFormat('d F Y') }}
                    </div>
                    <div>Telah menerima jumlah uang sebesar</div>
                    <div>Rp. {{ number_format($spd->total, 0, ',', '.') }}</div>
                    <div>Yang menerima</div>
                    <br><br><br>
                    <strong>
                        {{ $spd->ptk->nama_guru ?? $spd->ptk->nama ?? $spd->nama_ptk }}
                    </strong><br>
                    <span class="small">
                        NIP. {{ $spd->ptk->nip ?? $spd->nip_ptk ?? '-' }}
                    </span>
                </td>
            </tr>
        </table>

        <hr>

        {{-- SPD RAMPUNG --}}
        <div style="text-align:center;">
            <strong>PERHITUNGAN SPD RAMPUNG</strong>
            <table style="width:60%; margin-top:15px; text-align:left;">
                <tr>
                    <td>Ditetapkan sejumlah</td>
                    <td>:</td>
                    <td>Rp. {{ number_format($spd->total, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td>Yang telah dibayar sejumlah</td>
                    <td>:</td>
                    <td>Rp. {{ number_format($spd->total, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td>Sisa kurang/lebih</td>
                    <td>:</td>
                    <td>Rp. NIHIL</td>
                </tr>
            </table>
        </div>

        {{-- PPK --}}
        <div style="margin-top:24px; text-align:right;">
            <div style="display:inline-block; text-align:left;">
                <div>Pejabat Pembuat Komitmen</div>
                <br><br><br>
                <strong>Dudi Ruhyadi Muharam, S.Si., M.Si</strong><br>
                <span class="small">NIP. 197712112005011004</span>
            </div>
        </div>

    </div>
</div>
</div>
</body>
</html>

    </div>
</div>
@endsection
