@extends('layouts.admin')

@section('title', 'Tambah Pegawai - BGTK DKI')
@section('page_title', 'Tambah Data Pegawai')
@section('page_subtitle', 'Lengkapi identitas pegawai sesuai kebutuhan BGTK DKI Jakarta')

@section('content')

    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('pegawai.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <form action="{{ route('pegawai.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                {{-- FOTO PROFIL --}}
                <div class="row mb-4">
                    <div class="col-md-3 mx-auto text-center">
                        <img src="{{ asset('images/default-profile.png') }}" id="previewFoto" class="rounded shadow-sm mb-2"
                            style="width: 170px; height: 210px; object-fit: cover;">

                        <div class="mt-2">
                            <label class="form-label small fw-semibold">
                                Foto Pegawai (opsional)
                            </label>
                            <input type="file" name="foto" class="form-control form-control-sm" accept="image/*"
                                onchange="previewImage(this)">
                            <small class="text-muted d-block">
                                JPG / PNG • Maks 2MB
                            </small>
                        </div>
                    </div>
                </div>

                {{-- FORM DATA --}}
                <div class="row g-3">

                    {{-- Nama --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Nama Pegawai</label>
                        <input type="text" name="nama"
                            class="form-control form-control-sm @error('nama') is-invalid @enderror"
                            value="{{ old('nama') }}" required>
                        @error('nama')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- NIP --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">NIP</label>
                        <input type="text" name="nip" class="form-control form-control-sm" value="{{ old('nip') }}">
                    </div>

                    {{-- Golongan --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Golongan</label>
                        <input type="text" name="gol" class="form-control form-control-sm" value="{{ old('gol') }}">
                    </div>

                    {{-- Pangkat / Golongan --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Pangkat / Golongan</label>
                        <input type="text" name="pangkat_golongan" class="form-control form-control-sm"
                            value="{{ old('pangkat_golongan') }}">
                    </div>

                    {{-- Jabatan --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Jabatan</label>
                        <input type="text" name="jabatan" class="form-control form-control-sm" value="{{ old('jabatan') }}">
                    </div>

                    {{-- Status Kepegawaian --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Status Kepegawaian</label>
                        <input type="text" name="status_kepegawaian" class="form-control form-control-sm"
                            value="{{ old('status_kepegawaian') }}">
                    </div>

                    {{-- -Status Instansi --}}
                    <div class="mb-2">
                        <label class="form-label small">Instansi</label>
                        <input type="text" name="instansi" class="form-control form-control-sm"
                            value="{{ old('instansi', $pegawai->instansi ?? '') }}">
                    </div>


                    {{-- Email --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Email</label>
                        <input type="email" name="email" class="form-control form-control-sm" value="{{ old('email') }}">
                    </div>

                    {{-- Telepon --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">No. HP</label>
                        <input type="text" name="telepon" class="form-control form-control-sm" value="{{ old('telepon') }}">
                    </div>

                    {{-- Tanggal Lahir --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control form-control-sm"
                            value="{{ old('tanggal_lahir') }}">
                    </div>

                    {{-- Jenis Kelamin --}}
                    <div class="col-md-6">
                        <label class="form-label small fw-semibold">Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="form-select form-select-sm">
                            <option value="">Pilih Jenis Kelamin</option>
                            <option value="Laki-laki" {{ old('jenis_kelamin') == 'Laki-laki' ? 'selected' : '' }}>Laki-laki
                            </option>
                            <option value="Perempuan" {{ old('jenis_kelamin') == 'Perempuan' ? 'selected' : '' }}>Perempuan
                            </option>
                        </select>
                    </div>

                    {{-- Alamat --}}
                    <div class="col-md-12">
                        <label class="form-label small fw-semibold">Alamat</label>
                        <textarea name="alamat" class="form-control form-control-sm" rows="2">{{ old('alamat') }}</textarea>
                    </div>

                </div>

                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-primary btn-sm">
                        <i class="bi bi-save me-1"></i> Simpan
                    </button>
                </div>

            </form>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    document.getElementById('previewFoto').src = e.target.result;
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush