@extends('layouts.admin')

@section('title', 'Edit Peserta Pelatihan - BGTK DKI')
@section('page_title', 'Edit Peserta Pelatihan')
@section('page_subtitle', 'Perbarui data peserta dan status keikutsertaan pelatihan')

@section('content')
    <div class="card border-0 shadow-sm">
        <div class="card-body">
        <form action="{{ route('peserta.update', $peserta->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
                {{-- GURU / PTK --}}
                <div class="mb-3">
                <label class="form-label small fw-semibold">Pilih Guru / PTK <span class="text-danger">*</span></label>
                <select name="guru_id" id="guru_id" class="form-select form-select-sm" required>
                    @if(old('guru_id'))
                        @php
                            $guruSelected = \App\Models\Guru::with('sekolah')->find(old('guru_id'));
                        @endphp
                        @if($guruSelected)
                            <option value="{{ $guruSelected->id }}" selected>
                                {{ $guruSelected->nama_guru }}
                                @if($guruSelected->sekolah)
                                    — {{ $guruSelected->sekolah->nama ?? '' }}
                                @endif
                            </option>
                        @endif
                    @endif
                </select>
                @error('guru_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

                {{-- PELATIHAN --}}
                <div class="mb-3">
                    <label class="form-label small fw-semibold">Pelatihan <span class="text-danger">*</span></label>
                    <select name="pelatihan_id" class="form-select form-select-sm @error('pelatihan_id') is-invalid @enderror" required>
                        <option value="">Pilih pelatihan</option>
                        @foreach($pelatihanList as $p)
                            <option value="{{ $p->id }}"
                                {{ old('pelatihan_id', $peserta->pelatihan_id) == $p->id ? 'selected' : '' }}>
                                {{ $p->nama_pelatihan }}
                                @if($p->kategori)
                                    — {{ $p->kategori }}
                                @endif
                            </option>
                        @endforeach
                    </select>
                    @error('pelatihan_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                {{-- STATUS --}}
                <div class="mb-3">
                    <label class="form-label small fw-semibold">Status Peserta</label>
                    @php
                        $statusOld = old('status_keikutsertaan', $peserta->status_keikutsertaan ?? 'terdaftar');
                    @endphp
                    <select name="status_keikutsertaan" class="form-select form-select-sm @error('status_keikutsertaan') is-invalid @enderror">
                        <option value="terdaftar" {{ $statusOld === 'terdaftar' ? 'selected' : '' }}>Terdaftar</option>
                        <option value="lulus" {{ $statusOld === 'lulus' ? 'selected' : '' }}>Lulus</option>
                        <option value="tidak_lulus" {{ $statusOld === 'tidak_lulus' ? 'selected' : '' }}>Tidak lulus</option>
                    </select>
                    @error('status_keikutsertaan')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                {{-- SERTIFIKAT --}}
                <div class="mb-3">
                    <label class="form-label small fw-semibold">File Sertifikat</label>

                    @if($peserta->sertifikat_path)
                        <div class="mb-2 small">
                            Sertifikat saat ini:
                            <a href="{{ route('pelatihan.peserta.downloadSertifikat', $peserta) }}" target="_blank">
                                <i class="bi bi-file-earmark-arrow-down"></i> Unduh sertifikat
                            </a>
                        </div>
                    @endif

                    <input type="file"
                           name="sertifikat"
                           class="form-control form-control-sm @error('sertifikat') is-invalid @enderror"
                           accept=".pdf,.jpg,.jpeg,.png">
                    @error('sertifikat')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <div class="form-text small">
                        Isi jika ingin mengganti file sertifikat. Biarkan kosong jika tidak ada perubahan.
                    </div>
                </div>

                <hr class="my-3">

                <div class="d-flex justify-content-between gap-2">
                    <div class="d-flex gap-2">
                        <a href="{{ route('peserta.index') }}" class="btn btn-outline-secondary btn-sm">
                            Batal
                        </a>
                        <button type="submit" class="btn btn-primary btn-sm">
                            Update
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@push('scripts')
<script>
$(document).ready(function () {

    $('#guru_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'Cari guru / PTK...',
        allowClear: true,
        ajax: {
            url: "{{ route('guru.select2') }}",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term };
            },
            processResults: function (data) {
                return { results: data.results };
            }
        }
    });

});
</script>
=======
@endpush
