@extends('layouts.admin')

@section('title', 'Edit Registrasi Peserta')

@section('content')
<div class="container-fluid">

    <div class="card border-0 shadow-sm">
        <div class="card-header">
            <h6 class="mb-0">Edit Data Registrasi Peserta</h6>
        </div>

        <div class="card-body">
            <form action="{{ route('admin.registrasi.update', $registrasi) }}"
                  method="POST"
                  enctype="multipart/form-data">
                @csrf
                @method('PUT')

                {{-- ================= FOTO ================= --}}
                <h6 class="mb-3 text-primary text-center">Foto</h6>

                <div class="mb-4 text-center">

                    @if($registrasi->foto)
                        <div class="mb-3 d-flex justify-content-center">
                            <img src="{{ asset('storage/'.$registrasi->foto) }}"
                                class="img-thumbnail"
                                width="140"
                                alt="Foto Peserta">
                        </div>
                    @endif

                    <div class="d-flex justify-content-center">
                        <div style="max-width: 300px; width: 100%;">
                            <input type="file" name="foto" class="form-control form-control-sm">
                            <small class="text-muted d-block mt-1">
                                Kosongkan jika tidak ingin mengganti foto
                            </small>
                        </div>
                    </div>

                </div>


                {{-- ================= BIODATA ================= --}}
                <h6 class="mb-3 text-primary">Biodata Peserta</h6>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Pelatihan</label>
                        <select name="pelatihan_id" class="form-select form-select-sm">
                            @foreach($pelatihanList as $p)
                                <option value="{{ $p->id }}"
                                    {{ $registrasi->pelatihan_id == $p->id ? 'selected' : '' }}>
                                    {{ $p->nama_pelatihan }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Nama</label>
                        <input type="text" name="nama" class="form-control form-control-sm"
                               value="{{ old('nama', $registrasi->nama) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">NIK</label>
                        <input type="text" name="nik" class="form-control form-control-sm"
                               value="{{ old('nik', $registrasi->nik) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">NIP</label>
                        <input type="text" name="nip" class="form-control form-control-sm"
                               value="{{ old('nip', $registrasi->nip) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Jabatan</label>
                        <input type="text" name="jabatan" class="form-control form-control-sm"
                               value="{{ old('jabatan', $registrasi->jabatan) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Pangkat / Golongan</label>
                        <input type="text" name="pangkat_golongan" class="form-control form-control-sm"
                               value="{{ old('pangkat_golongan', $registrasi->pangkat_golongan) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="form-select form-select-sm">
                            <option value="Laki-laki" {{ $registrasi->jenis_kelamin == 'Laki-laki' ? 'selected' : '' }}>Laki-laki</option>
                            <option value="Perempuan" {{ $registrasi->jenis_kelamin == 'Perempuan' ? 'selected' : '' }}>Perempuan</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Agama</label>
                        <select name="agama" class="form-select form-select-sm">
                            @foreach($agamaOptions as $a)
                                <option value="{{ $a }}" {{ $registrasi->agama == $a ? 'selected' : '' }}>
                                    {{ $a }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Tempat Lahir</label>
                        <input type="text" name="tempat_lahir" class="form-control form-control-sm"
                               value="{{ old('tempat_lahir', $registrasi->tempat_lahir) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control form-control-sm"
                               value="{{ old('tanggal_lahir', $registrasi->tanggal_lahir) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">No HP</label>
                        <input type="text" name="no_hp" class="form-control form-control-sm"
                               value="{{ old('no_hp', $registrasi->no_hp) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Email Pribadi</label>
                        <input type="email" name="email_pribadi" class="form-control form-control-sm"
                               value="{{ old('email_pribadi', $registrasi->email_pribadi) }}">
                    </div>
                </div>

                {{-- ================= PENDIDIKAN ================= --}}
                <h6 class="mb-3 text-primary">Pendidikan</h6>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Pendidikan Terakhir</label>
                        <input type="text" name="pendidikan_terakhir" class="form-control form-control-sm"
                               value="{{ old('pendidikan_terakhir', $registrasi->pendidikan_terakhir) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Program Studi</label>
                        <input type="text" name="prodi" class="form-control form-control-sm"
                               value="{{ old('prodi', $registrasi->prodi) }}">
                    </div>
                </div>

                {{-- ================= ALAMAT RUMAH ================= --}}
                <h6 class="mb-3 text-primary">Alamat RUmah</h6>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Alamat rumah</label>
                        <input type="text" name="alamat_rumah" class="form-control form-control-sm"
                               value="{{ old('alamat_rumah', $registrasi->alamat_rumah) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Kab/Kota</label>
                        <input type="text" name="kab_kota_rumah" class="form-control form-control-sm"
                               value="{{ old('kab_kota_rumah', $registrasi->kab_kota_rumah) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Provinsi</label>
                        <input type="text" name="provinsi_rumah" class="form-control form-control-sm"
                               value="{{ old('provinsi_rumah', $registrasi->provinsi_rumah) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Kode Pos</label>
                        <input type="text" name="kode_pos_rumah" class="form-control form-control-sm"
                               value="{{ old('kode_pos_rumah', $registrasi->kode_pos_rumah) }}">
                    </div>
                </div>

                {{-- ================= UNIT KERJA ================= --}}
                <h6 class="mb-3 text-primary">Unit Kerja</h6>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Unit Kerja</label>
                        <input type="text" name="unit_kerja" class="form-control form-control-sm"
                               value="{{ old('unit_kerja', $registrasi->unit_kerja) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Kab/Kota</label>
                        <input type="text" name="kab_kota_unit" class="form-control form-control-sm"
                               value="{{ old('kab_kota_unit', $registrasi->kab_kota_unit) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Provinsi</label>
                        <input type="text" name="provinsi_unit" class="form-control form-control-sm"
                               value="{{ old('provinsi_unit', $registrasi->provinsi_unit) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Kode Pos</label>
                        <input type="text" name="kode_pos_unit" class="form-control form-control-sm"
                               value="{{ old('kode_pos_unit', $registrasi->kode_pos_unit) }}">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Telp Instansi</label>
                        <input type="text" name="telp_instansi" class="form-control form-control-sm"
                               value="{{ old('telp_instansi', $registrasi->telp_instansi) }}">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Alamat Unit Kerja</label>
                        <textarea name="alamat_unit_kerja" class="form-control form-control-sm" rows="2">{{ old('alamat_unit_kerja', $registrasi->alamat_unit_kerja) }}</textarea>
                    </div>
                </div>

                {{-- ================= BANK ================= --}}
                <h6 class="mb-3 text-primary">Data Bank</h6>

                <div class="row g-3 mb-4">
                    <div class="col-md-4">
                        <label class="form-label">NPWP</label>
                        <input type="text" name="npwp" class="form-control form-control-sm"
                               value="{{ old('npwp', $registrasi->npwp) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Bank</label>
                        <input type="text" name="bank" class="form-control form-control-sm"
                               value="{{ old('bank', $registrasi->bank) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">No Rekening</label>
                        <input type="text" name="no_rekening" class="form-control form-control-sm"
                               value="{{ old('no_rekening', $registrasi->no_rekening) }}">
                    </div>
                </div>

                

                {{-- ================= ACTION ================= --}}
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.registrasi.index') }}"
                       class="btn btn-secondary btn-sm">Kembali</a>
                    <button class="btn btn-primary btn-sm">
                        Simpan Perubahan
                    </button>
                </div>

            </form>
        </div>
    </div>

</div>
@endsection
