@php
    $kabupatenOptions = [
        'Jakarta Barat',
        'Jakarta Pusat',
        'Jakarta Selatan',
        'Jakarta Timur',
        'Jakarta Utara',
        'Kepulauan Seribu',
    ];
    $statusOptions = ['Negeri', 'Swasta'];
@endphp

<div class="row g-2">
    <div class="col-md-4">
        <label class="form-label form-label-sm small">Sekolah ID (Dapodik)</label>
        <input type="text" name="sekolah_id" class="form-control form-control-sm"
               value="{{ old('sekolah_id', $sekolah->sekolah_id ?? '') }}">
    </div>
    <div class="col-md-4">
        <label class="form-label form-label-sm small">NPSN</label>
        <input type="text" name="npsn" class="form-control form-control-sm"
               value="{{ old('npsn', $sekolah->npsn ?? '') }}">
    </div>
    <div class="col-md-4">
        <label class="form-label form-label-sm small">Nama Sekolah</label>
        <input type="text" name="nama" class="form-control form-control-sm"
               value="{{ old('nama', $sekolah->nama ?? '') }}" required>
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">Jenjang</label>
        <input type="text" name="jenjang" class="form-control form-control-sm"
               value="{{ old('jenjang', $sekolah->jenjang ?? '') }}">
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">Kabupaten</label>
        <select name="kabupaten" class="form-select form-select-sm">
            <option value="">Pilih kabupaten</option>
            @foreach($kabupatenOptions as $kab)
                <option value="{{ $kab }}" {{ old('kabupaten', $sekolah->kabupaten ?? '') == $kab ? 'selected' : '' }}>
                    {{ $kab }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">Kecamatan</label>
        <input type="text" name="kecamatan" class="form-control form-control-sm"
               value="{{ old('kecamatan', $sekolah->kecamatan ?? '') }}">
    </div>

    <div class="col-12">
        <label class="form-label form-label-sm small">Alamat</label>
        <input type="text" name="alamat_jalan" class="form-control form-control-sm"
               value="{{ old('alamat_jalan', $sekolah->alamat_jalan ?? '') }}">
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">Status Sekolah</label>
        <select name="status_sekolah" class="form-select form-select-sm">
            <option value="">Pilih status</option>
            @foreach($statusOptions as $st)
                <option value="{{ $st }}" {{ old('status_sekolah', $sekolah->status_sekolah ?? '') == $st ? 'selected' : '' }}>
                    {{ $st }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">No. Telepon</label>
        <input type="text" name="nomor_telepon" class="form-control form-control-sm"
               value="{{ old('nomor_telepon', $sekolah->nomor_telepon ?? '') }}">
    </div>

    <div class="col-md-4">
        <label class="form-label form-label-sm small">Email</label>
        <input type="email" name="email" class="form-control form-control-sm"
               value="{{ old('email', $sekolah->email ?? '') }}">
    </div>
</div>
