<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>@yield('title', 'Dashboard User - BGTK DKI')</title>

  {{-- Bootstrap 5 & Icons --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  {{-- Font: POPPINS --}}
  <link rel="preconnect" href="https://fonts.bunny.net">
  <link href="https://fonts.bunny.net/css?family=poppins:300,400,500,600,700,800,900" rel="stylesheet" />

  <style>
    :root{
      --bg: #f5f7ff;
      --card: #ffffff;
      --border: rgba(15,23,42,.08);
      --text: #0f172a;
      --muted: #64748b;

      --brand1: #4f46e5; /* indigo */
      --brand2: #06b6d4; /* cyan */
      --brand3: #22c55e; /* green */
      --brand4: #f97316; /* orange */

      --shadow: 0 14px 40px rgba(2,6,23,.10);
      --shadow-soft: 0 10px 26px rgba(2,6,23,.06);
    }

    html, body { height: 100%; }

    body{
      font-family: 'Poppins', system-ui, -apple-system, "Segoe UI", sans-serif;
      color: var(--text);
      background:
        radial-gradient(1100px 520px at 18% -12%, rgba(79,70,229,.16), transparent 60%),
        radial-gradient(900px 450px at 84% 0%, rgba(6,182,212,.14), transparent 56%),
        linear-gradient(180deg, #fbfdff, var(--bg));
    }

    /* NAVBAR */
    .navbar-user{
      background: rgba(255,255,255,.86);
      border-bottom: 1px solid var(--border);
      backdrop-filter: blur(14px);
      -webkit-backdrop-filter: blur(14px);
    }

    .navbar-user .navbar-brand{
      text-decoration: none;
    }

    .brand-badge{
        width: 38px; height: 38px;
        border-radius: 12px;
        background: #fff;
        border: 1px solid var(--border);
        display:flex; align-items:center; justify-content:center;
        box-shadow: 0 10px 22px rgba(2,6,23,.08);
    }

    .nav-link{
      font-weight: 600;
      color: rgba(15,23,42,.80) !important;
      padding: .55rem .8rem;
      border-radius: 10px;
    }

    .nav-link:hover{
      color: rgba(15,23,42,1) !important;
      background: rgba(79,70,229,.06);
    }

    .dropdown-menu{
      border: 1px solid var(--border);
      border-radius: 14px;
      box-shadow: var(--shadow);
      padding: 8px;
      min-width: 240px;
    }

    .dropdown-item{
      border-radius: 12px;
      padding: 10px 12px;
      font-weight: 600;
      font-size: .9rem;
    }

    .dropdown-item i{
      opacity: .85;
    }

    .dropdown-item:hover{
      background: rgba(79,70,229,.08);
    }

    .user-shell{
      max-width: 1080px; /* biar lebih “mirip mockup” */
      margin: 0 auto;
      padding: 18px 12px 30px;
    }

    .chip{
      font-size: 12px;
      border: 1px solid var(--border);
      padding: 8px 10px;
      border-radius: 999px;
      background: rgba(255,255,255,.75);
    }

    .avatar{
      width: 36px; height: 36px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--brand3), #16a34a);
      color:#fff;
      font-weight: 900;
      display:flex; align-items:center; justify-content:center;
      box-shadow: 0 10px 22px rgba(34,197,94,.22);
    }

    .btn-outline-dark{
      border-color: rgba(15,23,42,.16);
    }
    .btn-outline-dark:hover{
      background: rgba(15,23,42,.92);
      border-color: rgba(15,23,42,.92);
    }

    /* mobile sedikit rapihin */
    @media (max-width: 576px){
      .user-shell{ padding: 14px 10px 26px; }
      .nav-link{ padding: .5rem .65rem; }
      .dropdown-item{ font-size: .88rem; }
    }
  </style>

  @stack('styles')
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-user sticky-top">
  <div class="container-fluid px-3 px-md-4">

    <a class="navbar-brand d-flex align-items-center gap-2" href="{{ route('dashboard') }}">
    <div class="brand-badge p-0 overflow-hidden">
        <img src="{{ asset('images/Logo.png') }}" alt="Logo BGTK" style="width:100%;height:100%;object-fit:contain;">
    </div>
      <div class="d-flex flex-column lh-sm">
        <span class="fw-bold" style="font-size:.95rem;">BGTK DKI Jakarta</span>
        <span class="text-muted" style="font-size:.75rem;">Portal Data & Layanan Peserta</span>
      </div>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#userNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="userNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">

        {{-- Data Pokok --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
            Data Pokok
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('sekolah.index') ? route('sekolah.index') : '#' }}">
                <i class="bi bi-building me-2"></i>Data Sekolah
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('guru.index') ? route('guru.index') : '#' }}">
                <i class="bi bi-people me-2"></i>Data PTK
              </a>
            </li>
          </ul>
        </li>

        {{-- Pelatihan --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
            Pelatihan
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('pelatihan.index') ? route('pelatihan.index') : '#' }}">
                <i class="bi bi-mortarboard me-2"></i>Data Pelatihan
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('peserta.pelatihanSaya') ? route('peserta.pelatihanSaya') : '#' }}">
                <i class="bi bi-patch-check me-2"></i>Data Sertifikat
              </a>
            </li>
          </ul>
        </li>

        {{-- Dokumen Keuangan --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
            Dokumen Keuangan
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('admin.keuangan.spd.index') ? route('admin.keuangan.spd.index') : '#' }}">
                <i class="bi bi-receipt me-2"></i>SPPD
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="{{ \Illuminate\Support\Facades\Route::has('admin.keuangan.kuitansi.index') ? route('admin.keuangan.kuitansi.index') : '#' }}">
                <i class="bi bi-cash-coin me-2"></i>Kuitansi
              </a>
            </li>
          </ul>
        </li>

        {{-- (opsional) menu Form Registrasi kalau rute sudah ada --}}
        @if(\Illuminate\Support\Facades\Route::has('user.registrasi.create'))
          <li class="nav-item">
            <a class="nav-link" href="{{ route('user.registrasi.create') }}">
              Form Registrasi
            </a>
          </li>
        @endif

      </ul>

      <div class="d-flex align-items-center gap-2">
        <span class="chip d-none d-md-inline">
          <i class="bi bi-clock me-1"></i>{{ now()->format('d/m/Y H:i') }} WIB
        </span>

        <div class="d-flex align-items-center gap-2">
          <div class="d-none d-sm-flex flex-column text-end lh-sm">
            <span class="fw-bold" style="font-size:.85rem;">
              {{ auth()->user()->name ?? 'User' }}
            </span>
            <span class="text-muted" style="font-size:.72rem;">
              {{ auth()->user()->role->name ?? 'user' }}
            </span>
          </div>
          <div class="avatar">
            {{ strtoupper(substr(auth()->user()->name ?? 'U', 0, 1)) }}
          </div>
        </div>

        <form method="POST" action="{{ route('logout') }}" class="ms-1">
          @csrf
          <button type="submit" class="btn btn-outline-dark btn-sm rounded-pill px-3">
            <i class="bi bi-box-arrow-right me-1"></i>Keluar
          </button>
        </form>
      </div>
    </div>

  </div>
</nav>

<div class="user-shell">
  @yield('content')
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
@stack('scripts')
</body>
</html>
