@extends('layouts.portal')

@section('title', 'Portal Data BGTK DKI Jakarta')

@section('content')
<style>
    :root {
        --gov-navy: #1e3a8a;
        --gov-blue: #3b82f6;
        --gov-accent: #f59e0b;
        --surface-100: #f8fafc;
        --text-main: #1e293b;
    }

    /* Animasi Keyframes */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes scaleIn {
        from {
            opacity: 0;
            transform: scale(0.9);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-20px); }
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.05); }
    }

    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    @keyframes shimmer {
        0% { background-position: -1000px 0; }
        100% { background-position: 1000px 0; }
    }

    @keyframes rotate {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    /* Hero Section dengan Pola Geometris dan Animasi */
    .hero-banner {
        background: linear-gradient(135deg, var(--gov-navy) 0%, #1e40af 100%);
        background-image: radial-gradient(circle at 20% 30%, rgba(59, 130, 246, 0.2) 0%, transparent 50%),
                          url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        border-radius: 24px;
        padding: 4rem 2rem;
        position: relative;
        overflow: hidden;
        color: white;
        animation: fadeInDown 0.8s ease-out;
        box-shadow: 0 10px 40px rgba(30, 58, 138, 0.3);
    }

    .hero-banner::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: rotate 20s linear infinite;
        pointer-events: none;
    }

    .hero-banner .display-5 {
        animation: slideInLeft 1s ease-out 0.2s both;
    }

    .hero-banner .lead {
        animation: slideInLeft 1s ease-out 0.4s both;
    }

    .hero-banner .bi-bank {
        animation: float 3s ease-in-out infinite;
    }

    /* Search Box dengan Animasi Muncul */
    .search-container {
        max-width: 900px;
        margin: -45px auto 0;
        position: relative;
        z-index: 5;
        animation: scaleIn 0.6s ease-out 0.5s both;
    }

    .search-wrapper {
        background: #ffffff;
        padding: 1.5rem;
        border-radius: 20px;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        border: 1px solid rgba(226, 232, 240, 0.8);
        transition: all 0.3s ease;
    }

    .search-wrapper:hover {
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
        transform: translateY(-2px);
    }

    .form-control-custom {
        border: none;
        background: var(--surface-100);
        padding: 1rem 1.5rem;
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s ease;
    }

    .form-control-custom:focus {
        background: white;
        box-shadow: inset 0 0 0 2px var(--gov-blue);
        outline: none;
        transform: scale(1.01);
    }

    .search-icon {
        transition: all 0.3s ease;
    }

    .search-wrapper:hover .search-icon {
        color: var(--gov-blue) !important;
        transform: scale(1.1);
    }

    .btn-primary {
        background: linear-gradient(135deg, var(--gov-blue) 0%, #2563eb 100%);
        border: none;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .btn-primary::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        transition: left 0.5s ease;
    }

    .btn-primary:hover::before {
        left: 100%;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(59, 130, 246, 0.4);
    }

    /* Card Grid dengan Stagger Animation */
    .feature-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
        margin-top: 3rem;
    }

    .nav-card {
        background: white;
        border: 1px solid #e2e8f0;
        border-radius: 20px;
        padding: 2rem;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        flex-direction: column;
        height: 100%;
        text-decoration: none !important;
        color: var(--text-main);
        opacity: 0;
        animation: fadeInUp 0.6s ease-out forwards;
        position: relative;
        overflow: hidden;
    }

    .nav-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, var(--gov-blue), var(--gov-accent));
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s ease;
    }

    .nav-card:hover::before {
        transform: scaleX(1);
    }

    .nav-card:nth-child(1) { animation-delay: 0.7s; }
    .nav-card:nth-child(2) { animation-delay: 0.9s; }
    .nav-card:nth-child(3) { animation-delay: 1.1s; }

    .nav-card:hover {
        transform: translateY(-12px) scale(1.02);
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
        border-color: var(--gov-blue);
    }

    .icon-box {
        width: 64px;
        height: 64px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.75rem;
        margin-bottom: 1.5rem;
        transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        position: relative;
    }

    .icon-box::after {
        content: '';
        position: absolute;
        width: 100%;
        height: 100%;
        border-radius: 16px;
        background: inherit;
        opacity: 0;
        transform: scale(1.2);
        transition: all 0.4s ease;
    }

    .nav-card:hover .icon-box {
        transform: scale(1.15) rotate(-8deg);
    }

    .nav-card:hover .icon-box::after {
        opacity: 0.3;
        transform: scale(1.4);
    }

    .nav-card h4 {
        transition: color 0.3s ease;
    }

    .nav-card:hover h4 {
        color: var(--gov-blue);
    }

    .nav-card .text-primary {
        transition: all 0.3s ease;
    }

    .nav-card:hover .text-primary {
        transform: translateX(5px);
    }

    /* Badge dengan Animasi Pulse */
    .badge {
        animation: pulse 2s ease-in-out infinite;
    }

    /* Statistik Section dengan Animasi Counter */
    .stat-overview {
        background: white;
        border-radius: 24px;
        padding: 3rem;
        margin-top: 4rem;
        border: 1px solid #e2e8f0;
        animation: fadeInUp 0.8s ease-out 1.3s both;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .stat-overview:hover {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .stat-item {
        padding: 1.5rem;
        text-align: center;
        border-right: 1px solid #f1f5f9;
        transition: all 0.3s ease;
        position: relative;
    }

    .stat-item::before {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%) scaleX(0);
        width: 60%;
        height: 3px;
        background: linear-gradient(90deg, var(--gov-blue), var(--gov-accent));
        transition: transform 0.3s ease;
    }

    .stat-item:hover::before {
        transform: translateX(-50%) scaleX(1);
    }

    .stat-item:hover {
        background: linear-gradient(180deg, transparent, rgba(59, 130, 246, 0.05));
        transform: translateY(-5px);
    }

    .stat-item:last-child { border-right: none; }

    .stat-value {
        font-size: 2.5rem;
        font-weight: 800;
        background: linear-gradient(135deg, var(--gov-navy), var(--gov-blue));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        line-height: 1;
        margin-bottom: 0.5rem;
        transition: all 0.3s ease;
    }

    .stat-item:hover .stat-value {
        transform: scale(1.1);
    }

    .stat-label {
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #64748b;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .stat-item:hover .stat-label {
        color: var(--gov-blue);
    }

    /* Loading Shimmer Effect */
    .shimmer {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 1000px 100%;
        animation: shimmer 2s infinite;
    }

    /* Decorative Elements */
    .decoration-dot {
        width: 8px;
        height: 8px;
        background: var(--gov-blue);
        border-radius: 50%;
        display: inline-block;
        animation: pulse 1.5s ease-in-out infinite;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .stat-item { 
            border-right: none; 
            border-bottom: 1px solid #f1f5f9;
            padding: 1rem;
        }
        
        .stat-item:last-child {
            border-bottom: none;
        }
        
        .hero-banner { 
            padding: 2.5rem 1.5rem; 
            text-align: center;
            border-radius: 16px;
        }
        
        .stat-overview { 
            padding: 1.5rem;
            margin-top: 3rem;
        }

        .search-container {
            margin: -30px 1rem 0;
        }

        .search-wrapper {
            padding: 1rem;
        }

        .form-control-custom {
            padding: 0.875rem 1.25rem;
            font-size: 0.95rem;
        }

        .feature-grid {
            grid-template-columns: 1fr;
            gap: 1rem;
            margin-top: 2rem;
            padding: 0 1rem;
        }

        .nav-card {
            padding: 1.5rem;
        }

        .stat-value {
            font-size: 2rem;
        }

        .hero-banner .bi-bank {
            display: none !important;
        }
    }

    /* Dark Mode dengan Smooth Transition */
    [data-bs-theme="dark"] {
        --surface-100: #1e293b;
        --text-main: #e5e7eb;
    }

    [data-bs-theme="dark"] .nav-card,
    [data-bs-theme="dark"] .stat-overview,
    [data-bs-theme="dark"] .search-wrapper {
        background: #0f172a;
        border-color: #1e293b;
        color: #e5e7eb;
        transition: all 0.3s ease;
    }

    [data-bs-theme="dark"] .nav-card:hover {
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.6);
        background: #1e293b;
    }

    [data-bs-theme="dark"] .text-muted {
        color: #94a3b8 !important;
    }

    [data-bs-theme="dark"] .form-control-custom {
        background: #020617;
        color: #e5e7eb;
    }

    [data-bs-theme="dark"] .form-control-custom::placeholder {
        color: #64748b;
    }

    [data-bs-theme="dark"] .stat-value {
        background: linear-gradient(135deg, #60a5fa, #3b82f6);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    [data-bs-theme="dark"] .stat-item {
        border-color: #1e293b;
    }

    [data-bs-theme="dark"] .stat-item:hover {
        background: linear-gradient(180deg, transparent, rgba(59, 130, 246, 0.1));
    }

    [data-bs-theme="dark"] .badge.bg-light {
        background: #1e293b !important;
        color: #cbd5f5 !important;
    }

    [data-bs-theme="dark"] .hero-banner {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
    }

    /* Smooth Scroll */
    html {
        scroll-behavior: smooth;
    }

    /* Cursor Pointer untuk Interactive Elements */
    .nav-card, .stat-item, .btn {
        cursor: pointer;
    }
</style>

<div class="hero-banner shadow-sm">
    <div class="row align-items-center">
        <div class="col-lg-7">
            <h1 class="display-5 fw-bold mb-3">
                Pusat Data Terpadu BGTK DKI Jakarta
            </h1>
            <p class="lead opacity-90 mb-0">
                Akses informasi publik, manajemen kepegawaian, dan pemantauan program pengembangan tenaga kependidikan dalam satu pintu.
            </p>
        </div>
        <div class="col-lg-5 d-none d-lg-block text-end">
            <i class="bi bi-bank opacity-25" style="font-size: 10rem;"></i>
        </div>
    </div>
</div>

<div class="search-container">
    <div class="search-wrapper">
        <form action="{{ route('portal.guru.index') }}" method="GET" class="row g-2 align-items-center">
            <div class="col-md-9">
                <div class="position-relative">
                    <i class="bi bi-search position-absolute top-50 start-0 translate-middle-y ms-3 text-muted search-icon"></i>
                    <input type="text" name="q" class="form-control form-control-custom ps-5" 
                           placeholder="Cari berdasarkan Nama, NIP, atau NPSN Sekolah...">
                </div>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary w-100 py-2 fw-bold rounded-3 shadow-sm">
                    <i class="bi bi-search me-2"></i>Cari Data
                </button>
            </div>
        </form>
    </div>
</div>

<div class="feature-grid">
    <a href="{{ route('portal.guru.index') }}" class="nav-card">
        <div class="icon-box bg-primary bg-opacity-10 text-primary">
            <i class="bi bi-person-badge-fill"></i>
        </div>
        <h4 class="fw-bold mb-2">Database PTK / Guru</h4>
        <p class="text-muted small mb-3">Informasi detail profil PTK, status sertifikasi, dan riwayat kepegawaian yang diperbarui secara berkala.</p>
        <div class="mt-auto pt-3 text-primary fw-bold small d-flex align-items-center">
            Lihat Selengkapnya 
            <i class="bi bi-arrow-right ms-2"></i>
        </div>
    </a>

    <a href="#" class="nav-card">
        <div class="icon-box bg-success bg-opacity-10 text-success">
            <i class="bi bi-building-check"></i>
        </div>
        <h4 class="fw-bold mb-2">Profil Sekolah</h4>
        <p class="text-muted small mb-3">Pantau persebaran satuan pendidikan dan ketersediaan sarana prasarana di wilayah DKI Jakarta.</p>
        <span class="badge bg-light text-muted align-self-start mt-auto">
            <i class="bi bi-tools me-1"></i>Maintenance
        </span>
    </a>

    <a href="#" class="nav-card">
        <div class="icon-box bg-warning bg-opacity-10 text-warning">
            <i class="bi bi-mortarboard-fill"></i>
        </div>
        <h4 class="fw-bold mb-2">Program Diklat</h4>
        <p class="text-muted small mb-3">Cek jadwal pelatihan, pendaftaran bimtek, dan verifikasi sertifikat peningkatan kompetensi guru.</p>
        <span class="badge bg-light text-muted align-self-start mt-auto">
            <i class="bi bi-clock-history me-1"></i>Segera Hadir
        </span>
    </a>
</div>

<div class="stat-overview shadow-sm">
    <div class="row align-items-center">
        <div class="col-6 col-md-3 stat-item">
            <div class="stat-value count-up" data-count="{{ $stats['guru'] ?? 0 }}">0</div>
            <div class="stat-label">
                <i class="bi bi-person-fill-check me-1"></i>
                Guru Terdata
            </div>
        </div>

        <div class="col-6 col-md-3 stat-item">
            <div class="stat-value count-up" data-count="{{ $stats['sekolah'] ?? 0 }}">0</div>
            <div class="stat-label">
                <i class="bi bi-building me-1"></i>
                Satuan Pendidikan
            </div>
        </div>

        <div class="col-6 col-md-3 stat-item">
            <div class="stat-value count-up" data-count="{{ $stats['pelatihan'] ?? 0 }}">0</div>
            <div class="stat-label">
                <i class="bi bi-book me-1"></i>
                Program Diklat
            </div>
        </div>

        <div class="col-6 col-md-3 stat-item">
            <div class="stat-value count-up" data-count="{{ $stats['peserta_pelatihan'] ?? 0 }}">0</div>
            <div class="stat-label">
                <i class="bi bi-people me-1"></i>
                Peserta Aktif
            </div>
        </div>
    </div>

    <div class="row justify-content-center mt-4">
        <div class="col-12 col-md-4 stat-item text-center" style="border: none;">
            <div class="stat-value count-up" data-count="{{ $stats['pengunjung'] ?? 0 }}">0</div>
            <div class="stat-label">
                <i class="bi bi-eye me-1"></i>
                Total Pengunjung
            </div>
        </div>
    </div>

    @if(!empty($stats['last_updated']))
        <div class="mt-4 pt-3 border-top text-center text-muted small">
            <i class="bi bi-clock-history me-1"></i>
            Data diperbarui otomatis pada:
            <strong>{{ $stats['last_updated'] }}</strong>
        </div>
    @endif
</div>

@endsection

@push('scripts')
<script>
document.addEventListener("DOMContentLoaded", () => {
    const counters = document.querySelectorAll('.count-up');

    // Intersection Observer untuk animasi saat scroll
    const observerOptions = {
        threshold: 0.5,
        rootMargin: '0px'
    };

    const animateCounter = (el) => {
        const target = +el.dataset.count;
        const duration = 2000;
        const startTime = performance.now();

        const easeOutQuart = (t) => 1 - Math.pow(1 - t, 4);

        const update = (currentTime) => {
            const elapsed = currentTime - startTime;
            const progress = Math.min(elapsed / duration, 1);
            const easedProgress = easeOutQuart(progress);

            const value = Math.floor(easedProgress * target);
            el.innerText = value.toLocaleString('id-ID');

            if (progress < 1) {
                requestAnimationFrame(update);
            } else {
                el.innerText = target.toLocaleString('id-ID');
            }
        };

        requestAnimationFrame(update);
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting && !entry.target.classList.contains('counted')) {
                entry.target.classList.add('counted');
                animateCounter(entry.target);
            }
        });
    }, observerOptions);

    counters.forEach(counter => {
        observer.observe(counter);
    });

    // Parallax effect untuk hero banner
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        const hero = document.querySelector('.hero-banner');
        if (hero && scrolled < 500) {
            hero.style.transform = `translateY(${scrolled * 0.4}px)`;
            hero.style.opacity = 1 - (scrolled / 500);
        }
    });

    // Smooth hover effect untuk cards
    const cards = document.querySelectorAll('.nav-card');
    cards.forEach(card => {
        card.addEventListener('mousemove', (e) => {
            const rect = card.getBoundingClientRect();
            const x = e.clientX - rect.left;
            const y = e.clientY - rect.top;
            
            const centerX = rect.width / 2;
            const centerY = rect.height / 2;
            
            const rotateX = (y - centerY) / 20;
            const rotateY = (centerX - x) / 20;
            
            card.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) translateY(-12px) scale(1.02)`;
        });
        
        card.addEventListener('mouseleave', () => {
            card.style.transform = '';
        });
    });

    // Add ripple effect to buttons
    const buttons = document.querySelectorAll('.btn');
    buttons.forEach(button => {
        button.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            
            ripple.style.width = ripple.style.height = size + 'px';
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';
            ripple.style.position = 'absolute';
            ripple.style.borderRadius = '50%';
            ripple.style.background = 'rgba(255, 255, 255, 0.5)';
            ripple.style.transform = 'scale(0)';
            ripple.style.animation = 'ripple 0.6s ease-out';
            ripple.style.pointerEvents = 'none';
            
            this.style.position = 'relative';
            this.style.overflow = 'hidden';
            this.appendChild(ripple);
            
            setTimeout(() => ripple.remove(), 600);
        });
    });

    // Add CSS for ripple animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes ripple {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }
    `;
    document.head.appendChild(style);
});
</script>
@endpush