@extends('layouts.portal')

@section('title', 'Daftar Data Guru')

@section('content')

<div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2 mb-3">
    <div>
        <h4 class="fw-bold mb-1">Daftar Data Guru</h4>
        <div class="text-muted small">Ditemukan <span class="fw-bold">{{ number_format($guru->total()) }}</span> data</div>
    </div>
    <div class="badge-soft"><i class="bi bi-funnel me-1"></i>Gunakan filter untuk mempersempit hasil</div>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('portal.guru.index') }}" method="GET" class="row g-2 align-items-center">
            <div class="col-12 col-lg-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input type="text" name="q" value="{{ $filters['q'] ?? '' }}" class="form-control" placeholder="Cari Nama/Sekolah/NIK/NIP/NPSN">
                </div>
            </div>

            <div class="col-12 col-md-4 col-lg-3">
                <select name="wilayah" class="form-select">
                    <option value="">Wilayah</option>
                    @foreach($options['wilayah'] as $opt)
                        <option value="{{ $opt }}" @selected(($filters['wilayah'] ?? '') === $opt)>{{ $opt }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-12 col-md-4 col-lg-3">
                <select name="bidang_bahasa_id" class="form-select">
                    <option value="">Bidang</option>
                    @foreach($options['bidang'] as $b)
                        <option value="{{ $b->id }}" @selected((string)($filters['bidang_bahasa_id'] ?? '') === (string)$b->id)>{{ $b->nama_bahasa }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-12 col-md-4 col-lg-2">
                <select name="jenjang" class="form-select">
                    <option value="">Jenjang</option>
                    @foreach($options['jenjang'] as $opt)
                        <option value="{{ $opt }}" @selected(($filters['jenjang'] ?? '') === $opt)>{{ $opt }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-12 col-lg-auto">
                <button class="btn btn-primary w-100" type="submit">
                    <i class="bi bi-search me-1"></i>Cari
                </button>
            </div>

            <div class="col-12 col-lg-auto">
                <a class="btn btn-light w-100" href="{{ route('portal.guru.index') }}">
                    Reset
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th>Nama Guru</th>
                    <th class="d-none d-md-table-cell">Sekolah</th>
                    <th class="d-none d-md-table-cell">Kota / Kab.</th>
                    <th class="text-end">Aksi</th>
                </tr>
            </thead>

            <tbody>
            @forelse($guru as $g)
                <tr>
                    <td>
                        <div class="fw-semibold">{{ $g->nama_guru }}</div>
                        <div class="text-muted small">
                            {{ $g->nip ?: ($g->nik ?: ($g->nuptk ?: '-')) }}
                        </div>

                        {{-- Mobile info --}}
                        <div class="d-md-none text-muted small mt-1">
                            {{ $g->sekolah->nama ?? '-' }}
                        </div>
                        <div class="d-md-none small">
                            {{ $g->sekolah->kabupaten ?? ($g->kab_kota ?? '-') }}
                        </div>
                    </td>

                    <td class="d-none d-md-table-cell">
                        <div>{{ $g->sekolah->nama ?? '-' }}</div>
                        <div class="text-muted small">{{ $g->sekolah->npsn ?? '-' }}</div>
                    </td>

                    <td class="d-none d-md-table-cell">
                        {{ $g->sekolah->kabupaten ?? ($g->kab_kota ?? '-') }}
                    </td>

                    <td class="text-end">
                        <a href="{{ route('portal.guru.show', $g) }}"
                           class="btn btn-sm btn-outline-primary">
                            Detail
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center text-muted py-4">
                        Data tidak ditemukan
                    </td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>
</div>



<div class="d-flex justify-content-center mt-4">
    {{ $guru->links() }}
</div>

@endsection
