<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Daftar Hadir Fasilitator</title>

    <style>
        @page {
            size: A4;
            margin: 1.8cm 2cm 2cm 2.5cm;
        }

        body {
            font-family: "Times New Roman", serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            margin: 0;
            padding: 0;
        }

        /* ===== KOP ===== */
        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header img {
            width: 110%;
            margin-left: -5%;
        }

        /* ===== JUDUL ===== */
        .judul {
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
            margin: 10px 0 15px;
            font-size: 13pt;
        }

        /* ===== INFO ===== */
        table.info {
            width: 100%;
            margin: 15px 0 20px;
            border-collapse: collapse;
        }

        table.info td {
            padding: 2px 4px;
            vertical-align: top;
        }

        table.info td.label {
            width: 160px;
        }

        table.info td.titik {
            width: 10px;
            text-align: center;
        }

        /* ===== TABEL PRESENSI ===== */
        table.presensi {
            width: 100%;
            border-collapse: collapse;
            font-size: 10.5pt;
        }

        table.presensi th,
        table.presensi td {
            border: 1px solid #000;
            padding: 6px;
        }

        table.presensi th {
            text-align: center;
            font-weight: bold;
        }

        .hari {
            background: #eaeaea;
            font-weight: bold;
            text-align: center;
        }

        .center {
            text-align: center;
        }

        .italic {
            font-style: italic;
            font-weight: bold;
            text-align: center;
        }

        /* ===== TTD ===== */
        .ttd {
            height: 48px;
            vertical-align: bottom;
        }

        .ttd-box {
            height: 40px;
        }

        /* ===== FOOTER ===== */
        .footer {
            margin-top: 35px;
            width: 100%;
        }

        .footer .kanan {
            width: 45%;
            float: right;
            text-align: left;
            padding-left: 40px;
        }

        .clear {
            clear: both;
        }
    </style>
</head>

<body>

    <?php
        use Carbon\Carbon;
        Carbon::setLocale('id');

        // ===== KOP BASE64 =====
        $kopPath = public_path('images/kop_bgtk_terbaru.png');
        $kopSrc = '';

        if (file_exists($kopPath)) {
            $type = pathinfo($kopPath, PATHINFO_EXTENSION);
            $data = base64_encode(file_get_contents($kopPath));
            $kopSrc = "data:image/{$type};base64,{$data}";
        }
    ?>

    
    <div class="header">
        <?php if($kopSrc): ?>
            <img src="<?php echo e($kopSrc); ?>" alt="Kop Surat">
        <?php endif; ?>
    </div>

    
    <div class="judul">
        DAFTAR HADIR FASILITATOR
    </div>

    
    <table class="info">
        <tr>
            <td class="label">Nama Kegiatan</td>
            <td class="titik">:</td>
            <td><?php echo e($daftarHadir->suratTugas->nama_kegiatan); ?></td>
        </tr>
        <tr>
            <td class="label">Tanggal Pelaksanaan</td>
            <td class="titik">:</td>
            <td><?php echo e(Carbon::parse($daftarHadir->tanggal)->translatedFormat('l, d F Y')); ?></td>
        </tr>
        <tr>
            <td class="label">Tempat</td>
            <td class="titik">:</td>
            <td><?php echo e($daftarHadir->tempat); ?></td>
        </tr>
        <tr>
            <td class="label">Fasilitator</td>
            <td class="titik">:</td>
            <td>
                <?php $__currentLoopData = $daftarHadir->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($i + 1); ?>. <?php echo e($row->nama_manual); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
        </tr>
    </table>

    
    <table class="presensi">
        <thead>
            <tr>
                <th width="6%">No</th>
                <th width="18%">Hari & Waktu</th>
                <th width="36%">Materi</th>
                <th width="20%">Pemateri</th>
                <th width="20%">Tanda Tangan</th>
            </tr>
        </thead>
        <tbody>

            <tr>
                <td colspan="5" class="hari">
                    <?php echo e(Carbon::parse($daftarHadir->tanggal)->translatedFormat('l, d F Y')); ?>

                </td>
            </tr>

            <tr>
                <td class="center">1</td>
                <td class="center">07.45 - 08.30</td>
                <td>Registrasi dan Orientasi Kegiatan</td>
                <td class="center">Tim Fasilitator</td>
                <td class="ttd">
                    <div class="ttd-box"></div>
                </td>
            </tr>

            <tr>
                <td class="center">2</td>
                <td class="center">08.30 - 09.15</td>
                <td>Analisis Hasil Implementasi Open Class</td>
                <td class="center">Tim Fasilitator</td>
                <td class="ttd">
                    <div class="ttd-box"></div>
                </td>
            </tr>

            <tr>
                <td colspan="5" class="italic">Coffee Break</td>
            </tr>

            <tr>
                <td class="center">3</td>
                <td class="center">10.15 - 11.00</td>
                <td>Berbagi Pengalaman dan Strategi Implementasi PM</td>
                <td class="center">Tim Fasilitator</td>
                <td class="ttd">
                    <div class="ttd-box"></div>
                </td>
            </tr>

            <tr>
                <td colspan="5" class="italic">ISHOMA</td>
            </tr>

            <tr>
                <td class="center">4</td>
                <td class="center">13.30 - 15.00</td>
                <td>Refleksi Kegiatan dan Penutup</td>
                <td class="center">Tim Fasilitator</td>
                <td class="ttd">
                    <div class="ttd-box"></div>
                </td>
            </tr>

        </tbody>
    </table>

    
    <div class="footer">
        <div class="kanan">
            Jakarta, <?php echo e(Carbon::parse($daftarHadir->tanggal)->translatedFormat('d F Y')); ?><br>
            Panitia,<br><br><br><br><br>
            <strong><?php echo e($daftarHadir->suratTugas->pejabat_penandatangan); ?></strong><br>
            NIP. <?php echo e($daftarHadir->suratTugas->nip_penandatangan); ?>

        </div>
    </div>

    <div class="clear"></div>

</body>

</html><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/pdf/daftar-hadir-narasumber.blade.php ENDPATH**/ ?>