<?php $__env->startSection('page_title','Buat Daftar Hadir'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">

        <form method="POST" action="<?php echo e(route('daftar-hadir.store')); ?>">
            <?php echo csrf_field(); ?>

            
            <div class="mb-3">
                <label class="form-label fw-semibold">Surat Tugas</label>
                <select name="surat_tugas_id"
                        class="form-select <?php $__errorArgs = ['surat_tugas_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        required>
                    <option value="">-- Pilih Surat Tugas --</option>
                    <?php $__currentLoopData = $suratTugas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($st->id); ?>">
                            <?php echo e($st->nama_kegiatan); ?>

                            (<?php echo e($st->pegawais_count); ?> pegawai)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['surat_tugas_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tanggal</label>
                    <input type="date"
                           name="tanggal"
                           class="form-control"
                           value="<?php echo e(old('tanggal')); ?>"
                           required>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Tempat</label>
                    <input type="text"
                           name="tempat"
                           class="form-control"
                           value="<?php echo e(old('tempat')); ?>"
                           required>
                </div>
            </div>

            <hr>

            
            <div class="alert alert-info small">
                Peserta dari Surat Tugas akan otomatis masuk ke daftar hadir.
            </div>

            
            <h6 class="fw-bold mb-2">Peserta Manual (Opsional)</h6>

            <div id="manual-wrapper"></div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Peserta Manual
            </button>

            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Daftar Hadir
                </button>

                <a href="<?php echo e(route('daftar-hadir.index')); ?>"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const wrapper = document.getElementById('manual-wrapper');
    const btnAdd  = document.getElementById('btn-add');

    btnAdd.addEventListener('click', function () {

        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','manual-row');

        row.innerHTML = `
            <input type="text"
                   name="manual_new[]"
                   class="form-control"
                   placeholder="Nama peserta manual"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove">
                <i class="bi bi-trash"></i>
            </button>
        `;

        wrapper.appendChild(row);
    });

    wrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove')) {
            e.target.closest('.manual-row').remove();
        }
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/daftar-hadir/create.blade.php ENDPATH**/ ?>