

<?php $__env->startSection('page_title','Tambah Narasumber'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">

        <h6 class="fw-bold mb-3">
            <?php echo e($daftarHadir->suratTugas->nama_kegiatan); ?>

        </h6>

        <form method="POST"
              action="<?php echo e(route('daftar-hadir-narasumber.store', $daftarHadir->id)); ?>">
            <?php echo csrf_field(); ?>

            <div class="alert alert-info small">
                Semua narasumber diinput secara manual.
            </div>

            
            <div id="narasumber-wrapper">

                <div class="input-group mb-2 narasumber-row">
                    <input type="text"
                           name="nama_manual[]"
                           class="form-control"
                           placeholder="Nama narasumber"
                           required>

                    <button type="button"
                            class="btn btn-outline-danger btn-remove">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>

            </div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Narasumber
            </button>

            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Narasumber
                </button>

                <a href="<?php echo e(route('daftar-hadir.index')); ?>"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const wrapper = document.getElementById('narasumber-wrapper');
    const btnAdd = document.getElementById('btn-add');

    btnAdd.addEventListener('click', function () {
        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','narasumber-row');

        row.innerHTML = `
            <input type="text"
                   name="nama_manual[]"
                   class="form-control"
                   placeholder="Nama narasumber"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove">
                <i class="bi bi-trash"></i>
            </button>
        `;

        wrapper.appendChild(row);
    });

    wrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove')) {
            e.target.closest('.narasumber-row').remove();
        }
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/daftar-hadir/narasumber_create.blade.php ENDPATH**/ ?>