

<?php $__env->startSection('page_title','Kelola Narasumber'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">

        <h6 class="fw-bold mb-3">
            <?php echo e($daftarHadir->suratTugas->nama_kegiatan); ?>

        </h6>

        <form method="POST"
              action="<?php echo e(route('daftar-hadir-narasumber.update', $daftarHadir->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            
            <h6 class="fw-semibold mb-2">Daftar Narasumber</h6>

            <div id="existing-wrapper">
                <?php $__empty_1 = true; $__currentLoopData = $daftarHadir->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="input-group mb-2 narasumber-row">
                    <input type="text"
                           name="manual_existing[<?php echo e($row->id); ?>]"
                           class="form-control"
                           value="<?php echo e($row->nama_manual); ?>"
                           required>

                    <button type="button"
                            class="btn btn-outline-danger btn-remove-existing"
                            data-id="<?php echo e($row->id); ?>">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-muted small mb-2">
                    Belum ada narasumber
                </div>
                <?php endif; ?>
            </div>

            <hr>

            
            <h6 class="fw-semibold mb-2">Tambah Narasumber Baru</h6>

            <div id="new-wrapper"></div>

            <button type="button"
                    id="btn-add"
                    class="btn btn-sm btn-outline-primary mb-4">
                <i class="bi bi-plus-circle"></i> Tambah Narasumber
            </button>

            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    Simpan Perubahan
                </button>

                <a href="<?php echo e(route('daftar-hadir.index')); ?>"
                   class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const newWrapper = document.getElementById('new-wrapper');
    const btnAdd = document.getElementById('btn-add');
    const existingWrapper = document.getElementById('existing-wrapper');

    // tambah narasumber baru
    btnAdd.addEventListener('click', function () {
        const row = document.createElement('div');
        row.classList.add('input-group','mb-2','narasumber-new');

        row.innerHTML = `
            <input type="text"
                   name="manual_new[]"
                   class="form-control"
                   placeholder="Nama narasumber"
                   required>

            <button type="button"
                    class="btn btn-outline-danger btn-remove-new">
                <i class="bi bi-trash"></i>
            </button>
        `;

        newWrapper.appendChild(row);
    });

    // hapus input baru
    newWrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove-new')) {
            e.target.closest('.narasumber-new').remove();
        }
    });

    // hapus existing (langsung dari UI)
    existingWrapper.addEventListener('click', function (e) {
        if (e.target.closest('.btn-remove-existing')) {
            e.target.closest('.narasumber-row').remove();
        }
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/daftar-hadir/narasumber_edit.blade.php ENDPATH**/ ?>