<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin - BGTK DKI Jakarta'); ?></title>

    <link rel="shortcut icon" href="<?php echo e(asset('images/logo_terbaru1.png')); ?>" type="image/png">

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/compiled/css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/compiled/css/app-dark.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/compiled/css/iconly.css')); ?>">

    
    <script src="<?php echo e(asset('assets/static/js/initTheme.js')); ?>"></script>

    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</head>
<body>
<?php
    $isMaster = request()->routeIs('guru.*') || request()->routeIs('sekolah.*');
    $isPelatihan = request()->routeIs('pelatihan.*')
        || request()->routeIs('peserta.*')
        || request()->routeIs('admin.registrasi.*')
        || request()->routeIs('admin.pelatihan.kelas.*')
        || request()->routeIs('admin.kelas.*');
    $isKeuangan = request()->routeIs('admin.keuangan.*');
    $isLaporan  = request()->routeIs('admin.laporan.*');
?>

<div id="app">
    <div id="sidebar">
        <div class="sidebar-wrapper active">
            <div class="sidebar-header position-relative">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="logo">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="d-flex align-items-center gap-2">
                            <img src="<?php echo e(asset('images/Logo.png')); ?>" alt="BGTK" style="height: 34px; width: auto;">
                            <span class="fw-bold text-dark" style="font-size: 14px;">Dashboard Admin</span>
                        </a>
                    </div>

                    <div class="theme-toggle d-flex gap-2 align-items-center mt-2">
                        
                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="20" height="20" viewBox="0 0 21 21">
                            <g fill="none" fill-rule="evenodd" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M10.5 14.5c2.219 0 4-1.763 4-3.982a4.003 4.003 0 0 0-4-4.018c-2.219 0-4 1.781-4 4c0 2.219 1.781 4 4 4zM4.136 4.136L5.55 5.55m9.9 9.9l1.414 1.414M1.5 10.5h2m14 0h2M4.135 16.863L5.55 15.45m9.899-9.9l1.414-1.415M10.5 19.5v-2m0-14v-2" opacity=".3"></path>
                                <g transform="translate(-210 -1)">
                                    <path d="M220.5 2.5v2m6.5.5l-1.5 1.5"></path>
                                    <circle cx="220.5" cy="11.5" r="4"></circle>
                                    <path d="m214 5l1.5 1.5m5 14v-2m6.5-.5l-1.5-1.5M214 18l1.5-1.5m-4-5h2m14 0h2"></path>
                                </g>
                            </g>
                        </svg>

                        <div class="form-check form-switch fs-6">
                            <input class="form-check-input me-0" type="checkbox" id="toggle-dark" style="cursor: pointer">
                            <label class="form-check-label"></label>
                        </div>

                        
                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="20" height="20" viewBox="0 0 24 24">
                            <path fill="currentColor" d="m17.75 4.09l-2.53 1.94l.91 3.06l-2.63-1.81l-2.63 1.81l.91-3.06l-2.53-1.94L12.44 4l1.06-3l1.06 3l3.19.09m3.5 6.91l-1.64 1.25l.59 1.98l-1.7-1.17l-1.7 1.17l.59-1.98L15.75 11l2.06-.05L18.5 9l.69 1.95l2.06.05m-2.28 4.95c.83-.08 1.72 1.1 1.19 1.85c-.32.45-.66.87-1.08 1.27C15.17 23 8.84 23 4.94 19.07c-3.91-3.9-3.91-10.24 0-14.14c.4-.4.82-.76 1.27-1.08c.75-.53 1.93.36 1.85 1.19c-.27 2.86.69 5.83 2.89 8.02a9.96 9.96 0 0 0 8.02 2.89m-1.64 2.02a12.08 12.08 0 0 1-7.8-3.47c-2.17-2.19-3.33-5-3.49-7.82c-2.81 3.14-2.7 7.96.31 10.98c3.02 3.01 7.84 3.12 10.98.31Z" />
                        </svg>
                    </div>

                    <div class="sidebar-toggler x">
                        <a href="#" class="sidebar-hide d-xl-none d-block"><i class="bi bi-x bi-middle"></i></a>
                    </div>
                </div>
            </div>

            <div class="sidebar-menu">
                <ul class="menu">
                    <li class="sidebar-title">Menu</li>

                    <li class="sidebar-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="sidebar-link">
                            <i class="bi bi-grid-fill"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>

                    <li class="sidebar-item has-sub <?php echo e($isMaster ? 'active' : ''); ?>">
                        <a href="#" class="sidebar-link">
                            <i class="bi bi-database-fill"></i>
                            <span>Master Data</span>
                        </a>
                        <ul class="submenu">
                            <li class="submenu-item <?php echo e(request()->routeIs('pegawai.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('pegawai.index')); ?>" class="submenu-link">Data Pegawai BGTK</a>
                            </li>
                            <li class="submenu-item <?php echo e(request()->routeIs('guru.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('guru.index')); ?>" class="submenu-link">Data PTK</a>
                            </li>
                            <li class="submenu-item <?php echo e(request()->routeIs('sekolah.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('sekolah.index')); ?>" class="submenu-link">Data Sekolah</a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-item has-sub <?php echo e($isPelatihan ? 'active' : ''); ?>">
                        <a href="#" class="sidebar-link">
                            <i class="bi bi-journal-text"></i>
                            <span>Kegiatan</span>
                        </a>
                        <ul class="submenu">
                            <li class="submenu-item <?php echo e(request()->routeIs('pelatihan.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('pelatihan.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('pelatihan.*') ? 'active' : ''); ?>">
                                    <i class=""></i>
                                    Pelatihan
                                </a>
                            </li>
                            <li class="submenu-item <?php echo e(request()->routeIs('admin.registrasi.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.registrasi.index')); ?>" class="submenu-link">Registrasi Peserta</a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-item has-sub <?php echo e($isLaporan ? 'active' : ''); ?>">
                        <a href="#" class="sidebar-link">
                            <i class="bi bi-file-earmark-text"></i>
                            <span>Laporan</span>
                        </a>

                        <ul class="submenu">
                            <li class="submenu-item <?php echo e(request()->routeIs('admin.laporan-kegiatan.index') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.laporan-kegiatan.index')); ?>" class="submenu-link">
                                    Laporan Kegiatan
                                </a>
                            </li>

                            
                            <li class="submenu-item <?php echo e(request()->routeIs('admin.laporan.absensi.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.laporan-kegiatan.index')); ?>" class="submenu-link">
                                    Daftar Hadir Peserta
                                </a>
                            </li>

                            <li class="submenu-item <?php echo e(request()->routeIs('admin.laporan.absensi.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.laporan-kegiatan.index')); ?>" class="submenu-link">
                                    Daftar Hadir Fasil
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-item has-sub <?php echo e($isKeuangan ? 'active' : ''); ?>">
                        <a href="#" class="sidebar-link">
                            <i class="bi bi-cash-coin"></i>
                            <span>Keuangan</span>
                        </a>
                        <ul class="submenu">
                            <li class="submenu-item <?php echo e(request()->routeIs('admin.keuangan.spd.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.keuangan.spd.index')); ?>" class="submenu-link">Kuitansi Panjang</a>
                            </li>
                            <li class="submenu-item <?php echo e(request()->routeIs('admin.keuangan.kuitansi.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.keuangan.kuitansi.index')); ?>" class="submenu-link">Kuitansi</a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-item has-sub <?php echo e(request()->routeIs('sk.*', 'surat-tugas.*') ? 'active' : ''); ?>">
                        <a href="#" class="sidebar-link">
                            <i class="bi bi-envelope-paper-fill"></i>
                            <span>Surat-surat</span>
                        </a>

                        <ul class="submenu">

                            <li class="submenu-item <?php echo e(request()->routeIs('sk.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('sk.index')); ?>" class="submenu-link">
                                    SK Kegiatan
                                </a>
                            </li>

                            <li class="submenu-item <?php echo e(request()->routeIs('surat-tugas.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('surat-tugas.index')); ?>" class="submenu-link">
                                    Surat Tugas
                                </a>
                            </li>

                            <li class="submenu-item <?php echo e(request()->routeIs('daftar-hadir.*') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('daftar-hadir.index')); ?>" class="submenu-link">
                                    Daftar Hadir
                                </a>
                            </li>

                        </ul>
                    </li>

                    <li class="sidebar-title mt-3">Akun</li>

                    <li class="sidebar-item">
                        <form action="<?php echo e(route('logout')); ?>" method="POST" class="m-0">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="sidebar-link border-0 bg-transparent w-100 text-start">
                                <i class="bi bi-box-arrow-left"></i>
                                <span>Logout</span>
                            </button>
                        </form>
                    </li>

                </ul>
            </div>
        </div>
    </div>

    <div id="main" class="layout-navbar navbar-fixed">
        <header>
            <nav class="navbar navbar-expand navbar-light navbar-top">
                <div class="container-fluid">
                    <a href="#" class="burger-btn d-block">
                        <i class="bi bi-justify fs-3"></i>
                    </a>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mb-lg-0">
                            
                        </ul>

                        <div class="dropdown">
                            <a href="#" data-bs-toggle="dropdown" aria-expanded="false">
                                <div class="user-menu d-flex">
                                    <div class="user-name text-end me-3">
                                        <h6 class="mb-0 text-gray-600"><?php echo e(auth()->user()->name ?? 'Admin'); ?></h6>
                                        <p class="mb-0 text-sm text-gray-600"><?php echo e(auth()->user()->role->name ?? 'admin'); ?></p>
                                    </div>
                                    <div class="user-img d-flex align-items-center">
                                        <div class="avatar avatar-md">
                                            <img src="<?php echo e(asset('images/Logo.png')); ?>" alt="avatar">
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" style="min-width: 11rem;">
                                <li>
                                    <h6 class="dropdown-header">Hello, <?php echo e(auth()->user()->name ?? 'Admin'); ?>!</h6>
                                </li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li>
                                    <form action="<?php echo e(route('logout')); ?>" method="POST" class="m-0">
                                        <?php echo csrf_field(); ?>
                                        <button class="dropdown-item" type="submit">
                                            <i class="icon-mid bi bi-box-arrow-left me-2"></i> Logout
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </header>

        <div id="main-content">
            <div class="page-heading">
                <div class="page-title">
                    <div class="row">
                        <div class="col-12 col-md-6 order-md-1 order-last">
                            <h3><?php echo $__env->yieldContent('page_title', 'Dashboard'); ?></h3>
                            <?php if (! empty(trim($__env->yieldContent('page_subtitle')))): ?>
                                <p class="text-subtitle text-muted"><?php echo $__env->yieldContent('page_subtitle'); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-12 col-md-6 order-md-2 order-first">
                            <?php if (! empty(trim($__env->yieldContent('breadcrumbs')))): ?>
                                <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                                    <?php echo $__env->yieldContent('breadcrumbs'); ?>
                                </nav>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <section class="section">
                    <?php echo $__env->yieldContent('content'); ?>
                </section>
            </div>
        </div>

        <footer>
            <div class="footer clearfix mb-0 text-muted">
                <div class="float-start">
                    <p><?php echo e(date('Y')); ?> &copy; BGTK DKI Jakarta</p>
                </div>
                <div class="float-end">
                    <p>Dashboard Admin</p>
                </div>
            </div>
        </footer>
    </div>
</div>


<script src="<?php echo e(asset('assets/static/js/components/dark.js')); ?>"></script>
<script src="<?php echo e(asset('assets/extensions/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/compiled/js/app.js')); ?>"></script>


<script src="<?php echo e(asset('assets/extensions/jquery/jquery.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/layouts/admin.blade.php ENDPATH**/ ?>