<?php $__env->startSection('title', 'Data Pegawai BGTK - BGTK DKI'); ?>
<?php $__env->startSection('page_title', 'Data Pegawai BGTK'); ?>
<?php $__env->startSection('page_subtitle', 'Master data pegawai BGTK, informasi kepegawaian'); ?>

<?php $__env->startSection('content'); ?>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian & Filter Data Pegawai</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama, NIP, email, jabatan, atau golongan.
                    </small>
                </div>

                
                <div class="d-flex gap-2">
                    
                    <a href="<?php echo e(route('pegawai.export')); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-download me-1"></i> Export
                    </a>

                    
                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal"
                        data-bs-target="#modalImportPegawai">
                        <i class="bi bi-upload me-1"></i> Import
                    </button>
                </div>
            </div>

            
            <a href="<?php echo e(route('pegawai.create')); ?>" class="btn btn-success btn-sm mb-3">
                <i class="bi bi-plus-lg me-1"></i> Tambah Data
            </a>

            
            <form method="GET" action="<?php echo e(route('pegawai.index')); ?>" class="row g-2 align-items-end">

                <div class="col-12 col-md-4">
                    <label class="form-label small mb-1">Nama / NIP / Email</label>
                    <input type="text" name="search" value="<?php echo e($search ?? ''); ?>" class="form-control form-control-sm"
                        placeholder="Contoh: NIP, nama, atau email">
                </div>

                <div class="col-12 col-md-3">
                    <label class="form-label small mb-1">Jabatan</label>
                    <input type="text" name="jabatan" value="<?php echo e($jabatan ?? ''); ?>" class="form-control form-control-sm"
                        placeholder="Filter berdasarkan jabatan">
                </div>

                <div class="col-12 col-md-2 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="<?php echo e(route('pegawai.index')); ?>" class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>

            </form>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Pegawai BGTK</h6>
                <?php if(method_exists($pegawai, 'total')): ?>
                    <small class="text-muted">
                        Menampilkan <?php echo e($pegawai->total()); ?> data
                        (<?php echo e($pegawai->firstItem() ?? 0); ?> - <?php echo e($pegawai->lastItem() ?? 0); ?>)
                    </small>
                <?php endif; ?>
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Nama & NIP</th>
                            <th>Jabatan & Golongan</th>
                            <th>Tanggal Lahir & JK</th>
                            <th>Kontak</th>
                            <th>Status</th>
                            <th class="text-center" style="width: 90px;">Aksi</th>
                        </tr>
                    </thead>

                    <tbody class="small">
                        <?php $__empty_1 = true; $__currentLoopData = $pegawai; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>

                                            
                                            <td>
                                                <div class="fw-semibold"><?php echo e($p->nama); ?></div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    NIP: <?php echo e($p->nip ?? '-'); ?>

                                                </div>
                                            </td>

                                            
                                            <td>
                                                <div><?php echo e($p->jabatan ?? '-'); ?></div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    Gol: <?php echo e($p->gol ?? '-'); ?> / <?php echo e($p->pangkat_golongan ?? '-'); ?>

                                                </div>
                                            </td>

                                            
                                            <td>
                                                <div>
                                                    <?php echo e($p->tanggal_lahir
                            ? $p->tanggal_lahir->format('d-m-Y')
                            : '-'); ?>

                                                </div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    <?php echo e($p->jenis_kelamin ?? '-'); ?>

                                                </div>
                                            </td>

                                            
                                            <td>
                                                <div class="text-truncate" style="max-width: 180px;">
                                                    <?php echo e($p->email ?? '-'); ?>

                                                </div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    <?php echo e($p->telepon ?? '-'); ?>

                                                </div>
                                            </td>

                                            
                                            <td>
                                                <div><?php echo e($p->status_kepegawaian ?? '-'); ?></div>
                                                <div class="text-muted" style="font-size:11px;">
                                                    <?php echo e($p->instansi ?? '-'); ?>

                                                </div>
                                            </td>


                                            
                                            <td class="text-center">
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                                        data-bs-toggle="dropdown">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </button>

                                                    <ul class="dropdown-menu dropdown-menu-end small shadow">
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('pegawai.show', $p)); ?>">
                                                                <i class="bi bi-eye me-2 text-info"></i> Detail
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('pegawai.edit', $p)); ?>">
                                                                <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <hr class="dropdown-divider">
                                                        </li>
                                                        <li>
                                                            <form action="<?php echo e(route('pegawai.destroy', $p)); ?>" method="POST"
                                                                class="form-delete">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('DELETE'); ?>
                                                                <button type="button" class="dropdown-item text-danger btn-delete">
                                                                    <i class="bi bi-trash me-2"></i> Hapus
                                                                </button>
                                                            </form>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>

                                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    Belum ada data pegawai
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>

                </table>
            </div>

            
            <?php if(method_exists($pegawai, 'links')): ?>
                <div
                    class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3 small text-muted gap-2">
                    <div>
                        Menampilkan <?php echo e($pegawai->firstItem() ?? 0); ?> - <?php echo e($pegawai->lastItem() ?? 0); ?>

                        dari <?php echo e($pegawai->total()); ?> data
                    </div>
                    <div>
                        <?php echo e($pegawai->onEachSide(1)->links()); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="modal fade" id="modalImportPegawai" tabindex="-1" aria-labelledby="modalImportPegawaiLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="<?php echo e(route('pegawai.import')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h6 class="modal-title" id="modalImportPegawaiLabel">Import Data Pegawai</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p class="small text-muted mb-2">
                            Gunakan template Excel resmi (Data Pegawai) yang berisi kolom nama, NIP, gol, pangkat, jabatan,
                            email, telepon, alamat, tanggal lahir, dan jenis kelamin.
                        </p>
                        <div class="mb-2">
                            <label class="form-label small">File Excel (.xlsx / .xls)</label>
                            <input type="file" name="file" class="form-control form-control-sm" accept=".xlsx,.xls"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-dismiss="modal">
                            Batal
                        </button>
                        <button type="submit" class="btn btn-primary btn-sm">
                            Import
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <audio id="deleteSound">
        <source src="<?php echo e(asset('sounds/warning.mp3')); ?>" type="audio/mpeg">
    </audio>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const deleteButtons = document.querySelectorAll('.btn-delete');
            const sound = document.getElementById('deleteSound');

            function stopSound() {
                sound.pause();
                sound.currentTime = 0;
            }

            deleteButtons.forEach(btn => {
                btn.addEventListener('click', function () {
                    // 🔊 PLAY SOUND
                    stopSound(); // pastikan bersih dulu
                    sound.play();

                    // ⏳ Delay dikit biar kaget
                    setTimeout(() => {
                        const yakin = confirm(
                            "⚠️ PERINGATAN KERAS ⚠️\n\n" +
                            "Data pegawai akan DIHAPUS PERMANEN!\n" +
                            "Tindakan ini TIDAK bisa dibatalkan.\n\n" +
                            "Apakah kamu yakin?"
                        );

                        // 🛑 STOP SOUND SAAT USER PILIH
                        stopSound();

                        if (yakin) {
                            btn.closest('form').submit();
                        }
                    }, 300);
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/pegawai/index.blade.php ENDPATH**/ ?>