<?php $__env->startSection('title', 'Tambah Kuitansi'); ?>
<?php $__env->startSection('page_title', 'Tambah Kuitansi'); ?>
<?php $__env->startSection('page_subtitle', 'Input kuitansi pembayaran honor PTK'); ?>

<?php $__env->startSection('content'); ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger small">
            <strong>Terjadi kesalahan:</strong>
            <ul class="mb-0 mt-1">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($e); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.keuangan.kuitansi.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <h6 class="mb-3">Informasi Umum</h6>

                <div class="row g-3 small">
                    <div class="col-md-4">
                        <label class="form-label">PTK / Guru</label>
                        <select name="ptk" id="ptk" class="form-select form-select-sm js-ptk-select"
                            data-placeholder="Cari PTK / Guru" required>
                            <option value="">-- pilih PTK --</option>

                            <?php if(isset($selectedGuru) && $selectedGuru): ?>
                                <option value="<?php echo e($selectedGuru->id); ?>" selected>
                                    <?php echo e($selectedGuru->nama_guru); ?>

                                    <?php if($selectedGuru->nip): ?> - (<?php echo e($selectedGuru->nip); ?>) <?php endif; ?>
                                </option>
                            <?php endif; ?>
                        </select>
                        <small class="text-muted">
                            Ketik nama / NIP / NUPTK untuk mencari PTK.
                        </small>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Pelatihan</label>
                        <select name="pelatihan_id" class="form-select form-select-sm">
                            <option value="">-- opsional --</option>
                            <?php $__currentLoopData = $pelatihanList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($p->id); ?>" <?php echo e(old('pelatihan_id') == $p->id ? 'selected' : ''); ?>>
                                    <?php echo e($p->nama_pelatihan); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Tahun Anggaran</label>
                        <input type="text" name="tahun_anggaran" value="<?php echo e(old('tahun_anggaran', date('Y'))); ?>"
                            class="form-control form-control-sm" required>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Tanggal Kuitansi</label>
                        <input type="date" name="tanggal_kuitansi" value="<?php echo e(old('tanggal_kuitansi')); ?>"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Bukti Kas No.</label>
                        <input type="text" name="bukti_kas_no" value="<?php echo e(old('bukti_kas_no')); ?>"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Beban</label>
                        <input type="text" name="beban" value="<?php echo e(old('beban')); ?>" class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Akun</label>
                        <input type="text" name="akun" value="<?php echo e(old('akun')); ?>" class="form-control form-control-sm">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Sudah terima dari</label>
                        <input type="text" name="sudah_terima_dari"
                            value="<?php echo e(old('sudah_terima_dari', 'Kuasa Pengguna Anggaran/Pejabat Pembuat Komitmen BGTK Provinsi DKI Jakarta')); ?>"
                            class="form-control form-control-sm">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Untuk pembayaran</label>
                        <textarea name="untuk_pembayaran" class="form-control form-control-sm" rows="2"
                            required><?php echo e(old('untuk_pembayaran')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body small">
                <h6 class="mb-3">Perhitungan Honor</h6>

                <div class="row g-3">

                    
                    <div class="col-md-4">
                        <label class="form-label">
                            Honor Bruto (Rp)
                        </label>
                        <input type="number" name="honor_bruto" id="honor_bruto" value="<?php echo e(old('honor_bruto', 0)); ?>"
                            class="form-control form-control-sm" min="0" required>
                        <small class="text-muted">
                            Total honor yang dibayarkan (sudah termasuk transport jika ada)
                        </small>
                    </div>

                    
                    <div class="col-md-2">
                        <label class="form-label">
                            PPH 21 (%)
                        </label>
                        <input type="number" name="pph21_rate" value="<?php echo e(old('pph21_rate', 0)); ?>"
                            class="form-control form-control-sm" min="0" step="0.01">
                    </div>

                    <div class="col-md-6">
                        <small class="text-muted d-block mt-4">
                            Nilai PPH 21 dan jumlah diterima akan dihitung otomatis pada dokumen kuitansi.
                        </small>
                    </div>

                </div>

                
                <hr class="my-3">

                <div class="row g-3">

                    <div class="col-md-3">
                        <label class="form-label">
                            Transport / PP (Rp)
                        </label>
                        <input type="number" name="transport_nominal" id="transport_nominal"
                            class="form-control form-control-sm" min="0" placeholder="contoh: 150000">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">
                            Jumlah PP
                        </label>
                        <input type="number" name="transport_kali" id="transport_kali" class="form-control form-control-sm"
                            min="0" placeholder="contoh: 5">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">
                            Total Transport (Rp)
                        </label>
                        <input type="number" name="transport_total" id="transport_total"
                            class="form-control form-control-sm" readonly>
                        <small class="text-muted">
                            Otomatis: nominal × jumlah PP
                        </small>
                    </div>

                    <div class="col-md-3 d-flex align-items-end">
                        <small class="text-muted">
                            *Hanya sebagai bantuan hitung, tidak disimpan
                        </small>
                    </div>

                </div>
            </div>
        </div>


        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('admin.keuangan.kuitansi.index')); ?>" class="btn btn-outline-secondary">
                Kembali
            </a>
            <button type="submit" class="btn btn-primary">
                Simpan Kuitansi
            </button>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>

        $(document).ready(function () {

            function hitungTransport() {
                let nominal = parseInt($('#transport_nominal').val()) || 0;
                let kali = parseInt($('#transport_kali').val()) || 0;

                let total = nominal * kali;

                $('#transport_total').val(
                    total.toLocaleString('id-ID')
                );
            }

            $('#transport_nominal, #transport_kali').on('input', function () {
                hitungTransport();
            });

        });

        $(document).ready(function () {

            $('#ptk').select2({
                theme: 'bootstrap-5',
                placeholder: 'Cari PTK (Guru / Pegawai)',
                ajax: {
                    url: "<?php echo e(route('ptk.select2')); ?>",
                    dataType: 'json',
                    delay: 250,
                    data: params => ({ q: params.term }),
                    processResults: data => data
                }
            });


        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/keuangan/kuitansi/create.blade.php ENDPATH**/ ?>